<?php

namespace Booyah\ApiManagerClient\Client;

use GuzzleHttp\Psr7\Response as PSR7Response;

class Response extends PSR7Response
{
    public function isSuccessful()
    {
        return in_array($this->getStatusCode(), [
            '200',
            '201',
            '202',
            '203',
            '204',
            '205',
            '206',
            '207',
            '208',
            '226',
        ]);
    }

    public function bodyOverwrite($body)
    {
        if ($body !== '' && $body !== null) {
            $this->stream = stream_for($body);
        }
    }

    public function getContent()
    {
        $content = $this->getBody()->getContents();

        if ($this->hasHeader('Content-Type') && $this->getHeader('Content-Type')[0] === 'application/json') {
            return json_decode($content);
        }

        return $content;
    }
}
