<?php

declare(strict_types=1);

use Booyah\ApiManagerClient\ApiManger;
use Booyah\ApiManagerClient\Resources\CustomerResource;
use Booyah\ApiManagerClient\Resources\UserResource;
use PHPUnit\Framework\Assert;
use PHPUnit\Framework\TestCase;

class ClientTest extends TestCase
{
    public $domain = 'dev.api.booyah.cloud';

    public function testClientSuccess()
    {
        $resource = new CustomerResource();
        $endpoint = $resource->get('syncAll');
        $manager = new ApiManger($this->domain, 'auew', 'occ', true);
        $manager->setToken('$2y$10$.uyK560zUPd.E8Q2E3mowu8ZpZH3GtRh1yLUcjvx7DmB4v7EfsOuu');

        $res = $manager->get($endpoint, ['customernumber' => 1500105535]);
        var_dump($res);
        die;
        Assert::assertEquals(200, (int) $res['code']);
    }

    // public function testClientFail()
    // {
    //     $resource = new UserResource();
    //     $endpoint = $resource->get('user.check');
    //     $manager = new ApiManger($this->domain, 'auew', 'bocc', true);
    //     $manager->setToken('$2y$10$8GMP3qDfudrVEpcPniADUeSCO6WK.v.yhGKUhykXOZTiQBoHy1v5C');
    //
    //     $res = $manager->send($endpoint, ['email' => 1500007246]);
    //     dd($res);
    //     Assert::assertEquals(200, (int) $res['code']);
    // }
}
