<?php

namespace Booyah\ApiManagerClient;

use Illuminate\Support\ServiceProvider;

class ApiManagerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application events.
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/Config/apimanagerclient.php' => config_path('apimanagerclient.php')
        ], 'apimanager-client-config');
    }

    /**
     * Register the service provider.
     */
    public function register()
    {
        $this->app->bind('booyah-api-manager-client', function () {
            return new ApiManger(
                config('apimanagerclient.domain'),
                config('apimanagerclient.company_shortcut'),
                config('apimanagerclient.app_shortcut'),
                config('apimanagerclient.dev_mode')
            );
        });
    }
}
