<?php

namespace booyah\WOPP\Install;

class Installation
{
    protected $db;

    protected $prefix = 'booyah_wopp_';

    protected $resetToDefault = false;

    /**
     * @return void
     */
    public function __construct()
    {
        global $wpdb;

        $this->db = $wpdb;
    }

    public static function run()
    {
        $instance = new static();
        $instance->install();
    }

    public function install(): void
    {
        // if (! wp_next_scheduled('booyah_wopp_license_check')) {
        //     wp_schedule_event(time(), 'twice_daily', 'booyah_wopp_license_check');
        // }
        $this->createTables();
        $this->fillOrderOptions();
    }

    public function fillOrderOptions()
    {
        $orderFields = get_option('wopp_order_fields');
        $freshOrderFields = $this->getOrderFields();

        if ($orderFields === false) {
            update_option('wopp_order_fields', $freshOrderFields);
        } else {
            foreach ($freshOrderFields as $key => $values) {
                $old = data_get($orderFields, $key);

                if ($old !== null && ! $this->resetToDefault) {
                    data_set($values, 'is_active', data_get($old, 'is_active'));
                    data_set($values, 'is_required', data_get($old, 'is_required'));

                    if (count(data_get($values, 'options', [])) > 0) {
                        $options = data_get($values, 'options');
                        $oldOptions = data_get($orderFields[$key], 'options', []);

                        foreach ($options as $optionKey => $optionValue) {
                            data_set($options, $optionKey . '.is_active', data_get($oldOptions, $optionKey . '.is_active', false));
                        }

                        data_set($values, 'options', $options);
                    }
                }

                $freshOrderFields[$key] = $values;
            }

            update_option('wopp_order_fields', $freshOrderFields);
        }
    }

    /**
     * Describe me
     * @return void
     */
    private function createTables()
    {
        $this->createTable('products', 1.1);
        $this->createTable('media_product', 1.1);
        $this->createTable('advantages', 1);
        $this->createTable('prices', 1.3);
        $this->createTable('orders', 1.1);
    }

    /**
     * Create/Update Table
     *
     * @param string $table
     * @param $version
     *
     * @return void
     */
    private function createTable($table, $version)
    {
        $tableVersionKey = $this->prefix.$table;
        $installedVersion = get_option($tableVersionKey);

        if ($installedVersion >= $version) {
            return;
        }

        $charset = $this->db->get_charset_collate();

        $tableName = $this->db->prefix . $this->prefix.$table;
        $sql = require_once "database/{$table}.php";

        dbDelta(sprintf($sql, $tableName, $charset));
        update_option($tableVersionKey, $version);
    }

    private function getOrderFields()
    {
        $fields = [
            'salutation' => [
                'parent' => 'personalData',
                'options' => [
                    'mr' => ['is_active' => false],
                    'mrs' => ['is_active' => false],
                    'other' => ['is_active' => false],
                ],
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'first_name' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'last_name' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'title' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'birthday' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['date'],
            ],
            'phone_number' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'email' => [
                'parent' => 'personalData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['email'],
            ],
            'meter_number' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'order_type' => [
                'parent' => 'orderData',
                'options' => [
                    'change' => ['is_active' => false],
                    'move' => ['is_active' => false],
                ],
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'previous_supplier_code' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:order_type,change'],
            ],
            'desired_at' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:order_type,change'],
            ],
            'cancelled_at' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'moving_in_at' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:order_type,move'],
            ],
            'reading_at' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'meter_reading' => [
                'parent' => 'orderData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'shipping_postcode' => [
                'parent' => 'shippingData',
                'is_active' => false,
                'is_required' => true,
                'show' => false,
            ],
            'shipping_city' => [
                'parent' => 'shippingData',
                'is_active' => false,
                'is_required' => true,
                'show' => false,
            ],
            'shipping_street' => [
                'parent' => 'shippingData',
                'is_active' => false,
                'is_required' => true,
                'show' => false,
            ],
            'shipping_house_number' => [
                'parent' => 'shippingData',
                'is_active' => false,
                'is_required' => true,
                'show' => false,
            ],
            'billing_first_name' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'billing_last_name' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'billing_postcode' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'billing_city' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'billing_street' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'billing_house_number' => [
                'parent' => 'billingData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'payment_method' => [
                'parent' => 'paymentData',
                'options' => [
                    'sepa' => ['is_active' => false],
                    'transfer' => ['is_active' => false],
                    'paypal' => ['is_active' => false],
                ],
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'account_owner' => [
                'parent' => 'paymentData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:payment_method,sepa'],
            ],
            'iban' => [
                'parent' => 'paymentData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:payment_method,sepa'],
            ],
            'bic' => [
                'parent' => 'paymentData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'bankname' => [
                'parent' => 'paymentData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
            ],
            'paypal_email' => [
                'parent' => 'paymentData',
                'is_active' => false,
                'is_required' => false,
                'show' => true,
                'rules' => ['required_if:payment_method,paypal', 'email'],
            ],
        ];

        return $fields;
    }
}
