$( window ).on( 'load', function () {

    /***************************************************************************
    /* Produktverwaltung 
    ***************************************************************************/
    var productForm = $( 'body' ).find( '.wopp-admin-product--form' );
    productForm.find( '#add-file' ).on( 'click', function () {
        var row = $( '#template tr' ).clone().removeAttr( 'style' );
        row.insertBefore( productForm.find( '.wopp-admin-product--form--submit' ) );
    } );


    var btnMediaSelect = productForm.find( ".media-select" );

    var mediaSelect = wp.media( {
        multiple: false,
        target_id: null,
        library: {
            type: 'application/pdf'
        },
    } );

    mediaSelect.on( "select", function () {
        var mediaData = mediaSelect.state().get( "selection" ).first().toJSON();
        var $targetElem;

        jQuery.each( mediaData, function ( k, v ) {
            $targetElem = jQuery( mediaSelect.parent_element ).find( "[data-media='" + mediaSelect.target_id + "'][data-media-attr='" + k + "']" );
            console.log( $targetElem );
            if ( $targetElem.is( "img" ) ) {
                $targetElem.attr( "src", v );
            } else if ( $targetElem.is( "a" ) ) {
                $targetElem.attr( "href", v );
            } else if ( $targetElem.is( ":input" ) ) {
                $targetElem.val( v );
            } else {
                $targetElem.text( v );
            }
        } );
    } );

    productForm.delegate( '.remove-file-link', 'click', function ( $e ) {
        $( this ).parents( '.file_row' ).remove();
    } );

    productForm.delegate( ".media-select", "click", function ( e ) {
        e.preventDefault();
        mediaSelect.target_id = jQuery( this ).data( "media-target" );
        mediaSelect.parent_element = jQuery( this ).parents( '.file_row' );
        mediaSelect.open();
    } );

    var imageSelect = wp.media( {
        multiple: false,
        target_id: null,
        library: {
            type: 'image/*'
        },

    } );

    imageSelect.on( "select", function () {
        var mediaData = imageSelect.state().get( "selection" ).first().toJSON();
        var $targetElem;

        jQuery.each( mediaData, function ( k, v ) {
            $targetElem = jQuery( "[data-media='" + imageSelect.target_id + "'][data-media-attr='" + k + "']" );
            if ( $targetElem.is( "img" ) ) {
                $targetElem.attr( "src", v );
            } else if ( $targetElem.is( "a" ) ) {
                $targetElem.attr( "href", v );
            } else if ( $targetElem.is( ":input" ) ) {
                $targetElem.val( v );
            } else {
                $targetElem.text( v );
            }
        } );
    } );


    productForm.delegate( ".image-select", "click", function ( e ) {
        e.preventDefault();
        imageSelect.target_id = jQuery( this ).data( "media-target" );
        imageSelect.open();
    } );

    /***************************************************************************
    /* Produktvorteile 
    ***************************************************************************/
    var advantageForm = $( 'body' ).find( '.wopp-admin-advantage--form' );
    advantageForm.find( '#add-advantage' ).on( 'click', function () {
        var row = $( '#template tbody' ).clone();
        row.insertBefore( advantageForm.find( '.wopp-admin-advantage--form--submit' ) );
    } );

    advantageForm.delegate( '.remove-advantage', 'click', function ( e ) {
        e.preventDefault();
        jQuery( this ).parents( '.advantage-group' ).remove();
    } );
} );
