<?php

namespace booyah\WOPP\Models;

use booyah\WOPP\Models\Traits\SoftDeletes;

class Price extends Model
{
    use SoftDeletes;

    protected $table = 'prices';

    protected $fillable = [
        'is_blacklist',
        'postcodes',
        'networknumber',
        'valid_from',
        'valid_to',
        'application_from',
        'application_to',
        'usage_price_et',
        'usage_price_ht',
        'usage_price_nt',
        'base_price',
        'usage_from',
        'usage_to',
    ];

    protected $casts = [
        'is_blacklist' => 'bool',
    ];

    /**
     * @param string $value
     */
    public function setUsagePriceEtAttribute($value)
    {
        $this->attributes['usage_price_et'] = (float) str_replace(',', '.', $value);
    }

    /**
     * @param string $value
     */
    public function setUsagePriceHtAttribute($value)
    {
        $this->attributes['usage_price_ht'] = (float) str_replace(',', '.', $value);
    }

    /**
     * @param string $value
     */
    public function setUsagePriceNtAttribute($value)
    {
        $this->attributes['usage_price_nt'] = (float) str_replace(',', '.', $value);
    }

    /**
     * @param string $value
     */
    public function setBasePriceAttribute($value)
    {
        $this->attributes['base_price'] = (float) str_replace(',', '.', $value);
    }
}
