<?php

namespace booyah\WOPP\Models\Traits;

use booyah\WOPP\Helpers\Str;

trait GuardAttributes
{
    /**
     * @var array
     */
    protected $fillable = [];

    /**
     * @return array
     */
    public function getFillable()
    {
        return $this->fillable;
    }

    /**
     * @param array $fillable
     * @return $this
     */
    public function fillable(array $fillable)
    {
        $this->fillable = $fillable;

        return $this;
    }

    /**
     * @param string $key
     * @return bool
     */
    public function isFillable($key)
    {
        if (in_array($key, $this->getFillable())) {
            return true;
        }

        return empty($this->getFillable()) && ! Str::startsWith($key, '_');
    }
}
