<?php

namespace booyah\WOPP\Services;

use booyah\WOPP\Helpers\Fluent;
use booyah\WOPP\Models\Price;
use booyah\WOPP\Models\Product;

class PriceCalculationService
{
    /**
     * @var Product
     */
    protected $product;

    /**
     * @var int
     */
    protected $usage;

    /**
     * @var string
     */
    protected $date;

    /**
     * @var string
     */
    protected $postcode;

    /**
     * @var bool
     */
    protected $is_htnt = false;

    /**
     * @var int
     */
    protected $usageNt;

    public function __construct()
    {
        $this->date = date('Y-m-d H:i:s');
    }

    /**
     * @param Product $product
     *
     * @return $this
     */
    public function setProduct(Product $product): self
    {
        $this->product = $product;

        return $this;
    }

    /**
     * @param int $usage
     *
     * @return $this
     */
    public function setUsage($usage): self
    {
        $this->usage = $usage;

        return $this;
    }

    /**
     * @param string $date
     *
     * @return $this
     */
    public function setDate($date): self
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @param $postcode
     *
     * @return $this
     */
    public function setPostcode($postcode): self
    {
        $this->postcode = $postcode;

        return $this;
    }

    /**
     * @param $usage
     *
     * @return $this
     */
    public function setUsageNt($usage): self
    {
        $this->usageNt = $usage;
        $this->is_htnt = true;

        return $this;
    }

    public function calculate()
    {
        global $wpdb;

        $result = $wpdb->get_row($this->getQuery($this->usage), ARRAY_A);

        $price = new Price();
        $price->fillFromDatabase($result);

        $ret = new Fluent([
            'basePrice' => $price->base_price,
            'usage' => $this->usage,
        ]);

        if ($this->is_htnt) {
            $result = $wpdb->get_row($this->getQuery($this->usageNt), ARRAY_A);

            $priceNt = new Price();
            $priceNt->fillFromDatabase($result);

            $ret->usageNt = $this->usageNt;
            $ret->usagePriceHt = $price->usage_price_ht;
            $ret->usagePriceNt = $priceNt->usage_price_ht;
            $ret->yearly = ($ret->usagePriceHt * $this->usage) + ($ret->usagePriceNt * $this->usageNt) + ($ret->basePrice * 12);
            $ret->monthly = ceil($ret->yearly / 12);
        } else {
            $ret->usagePrice = $price->usage_price_et;
            $ret->yearly = ($ret->usage_price * $this->usage) + ($ret->basePrice * 12);
            $ret->monthly = ceil($ret->yearly / 12);
        }

        return $ret;
    }

    public function getQuery($usage)
    {
        return '
            SELECT * FROM ' . Price::getTable() . '
            WHERE product_id = ' . $this->product->id . '
            AND valid_from <= "' . $this->date . '"
            AND valid_to >= "' . $this->date . '"
            AND application_from <= "' . $this->date . '"
            AND application_to >= "' . $this->date . '"
            AND usage_from <= ' . $usage . '
            AND usage_to >= ' . $usage . '
            AND (
                (is_blacklist = 1 AND (postcodes NOT LIKE "%' . $this->postcode . '%" OR postcodes IS NULL))
                OR (is_blacklist = 0 AND (postcodes LIKE "%' . $this->postcode . '%" AND postcodes IS NOT NULL))
            )
            ORDER BY id desc;
        ';
    }
}