<form action="{{ menu_page_url('bew-orders-export-download', false) }}" method="post">
    <div>
        <label for="delimiter">{{ __('Delimiter', LANG_DOMAIN) }}</label>
        <select id="delimiter" name="delimiter">
            <option value="1">{{ __('Comma', LANG_DOMAIN) }} (,)</option>
            <option value="2">{{ __('Semicolon', LANG_DOMAIN) }} (;)</option>
        </select>
    </div>
    <div>
        <label for="enclosure">{{ __('Enclosure', LANG_DOMAIN) }}</label>
        <select id="enclosure" name="enclosure">
            <option value="1">{{ __('Quotation marks', LANG_DOMAIN) }} (")</option>
            <option value="2">{{ __('Apostrophe', LANG_DOMAIN) }} (')</option>
        </select>
    </div>
    <div>
        <label for="start">{{ __('Start date', LANG_DOMAIN) }}</label>
        <input id="start" name="start">
    </div>
    <div>
        <label for="end">{{ __('End date', LANG_DOMAIN) }}</label>
        <input id="end" name="end">
    </div>
    <div>
        <label for="order_type">{{ __('Type', LANG_DOMAIN) }}</label>
        <select id="order_type" name="order_type">
            <option value="1">{{ __('Not exported', LANG_DOMAIN) }}</option>
            <option value="2">{{ __('Only exported', LANG_DOMAIN) }}</option>
            <option value="3">{{ __('All orders', LANG_DOMAIN) }}</option>
        </select>
    </div>
    <div>
        <label for="products">{{ __('Products') }} {{ __('(If no products are selected, all products are exported)') }}</label>
        <select id="products" name="products[]" multiple>
            @foreach ($products as $product)
                <option value="{{ $product->id }}">{{ $product->name }}</option>
            @endforeach
        </select>
    </div>
    <div>
        <button type="submit">{{ __('Export orders', LANG_DOMAIN) }}</button>
    </div>
</form>