<div class="wrap">
    <h1 class="wp-heading-inline"><?= __('Orders', LANG_DOMAIN) ?></h1>

    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4"><b>Persönliche Informationen</b></th>
        </tr>
        <tr>
            <th>Titel</th>
            <td><?= $order->title ?></td>
            <th>Anrede</th>
            <td><?= $order->salutation ?></td>
        </tr>
        <tr>
            <th>Vorname</th>
            <td><?= $order->first_name ?></td>
            <th>Nachname</th>
            <td><?= $order->last_name ?></td>
        </tr>
        <tr>
            <th>Geburtstag</th>
            <td><?= format_date($order->birthday) ?></td>
            <th>Telefon-Nr.</th>
            <td><?= $order->phone_number ?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td colspan="3"><?= $order->email ?></td>
        </tr>
        <tr>
            <th colspan="4"><b>Produktinformationen</b></th>
        </tr>
        <tr>
            <th>Produkt</th>
            <td><?= $product->name ?></td>
            <th>Sparte</th>
            <td><?= format_energy_type($product->energy_type) ?></td>
        </tr>
        <tr>
            <th colspan="4"><b>Bestellinformationen</b></th>
        </tr>
        <tr>
            <th>Wechselart</th>
            <td><?= $order->order_type ?></td>
            <th>Zählernummmer</th>
            <td><?= $order->meter_number ?></td>
        </tr>
        <tr>
            <th>Vorversorger Code</th>
            <td><?= $order->previous_supplier_code ?></td>
            <th>Vorversorger Name</th>
            <td><?= $order->previous_supplier_name ?></td>
        </tr>
        <tr>
            <th>Vorversorger Kundennummer</th>
            <td><?= $order->previous_supplier_customer_number ?></td>
            <th>Wunschtermin</th>
            <td><?= format_date($order->desired_at) ?></td>
        </tr>
        <tr>
            <th>Bereits gekündigt</th>
            <td><?= $order->is_cancelled == '1' ? 'Ja' : 'Nein' ?></td>
            <th>Gekündigt zum</th>
            <td><?= format_date($order->cancelled_at) ?></td>
        </tr>
        <tr>
            <th>Einzugsdatum</th>
            <td><?= format_date($order->moving_in_at) ?></td>
            <th>Ablesedatum</th>
            <td><?= format_date($order->reading_at) ?></td>
        </tr>
        <tr>
            <th>Zählerstand</th>
            <td colspan="3"><?= $order->meter_reading ?></td>
        </tr>
        <tr>
            <th colspan="4"><b>Lieferadresse</b></th>
        </tr>
        <tr>
            <th>Lieferadresse Postleitzahl</th>
            <td><?= $order->shipping_postcode ?></td>
            <th>Lieferadresse Ort</th>
            <td><?= $order->shipping_city ?></td>
        </tr>
        <tr>
            <th>Lieferadresse Straße</th>
            <td><?= $order->shipping_street ?></td>
            <th>Lieferadresse Hausnummer</th>
            <td><?= $order->shipping_house_number ?></td>
        </tr>
        <tr>
            <th colspan="4"><b>Rechnungsadresse</b></th>
        </tr>
        <tr>
            <th>Andere Rechnungsadresse</th>
            <td><?= $order->is_billing_address_different == '1' ? 'Ja' : 'Nein' ?></td>
            <th></th>
            <td><?= $order->billing_first_name ?></td>
        </tr>
        <tr>
            <th>Rechnungsadresse Vorname</th>
            <td><?= $order->billing_last_name ?></td>
            <th>Rechnungsadresse Nachname</th>
            <td><?= $order->billing_postcode ?></td>
        </tr>
        <tr>
            <th>Rechnungsadresse Ort</th>
            <td><?= $order->billing_city ?></td>
            <th>Rechnungsadresse Straße</th>
            <td><?= $order->billing_street ?></td>
        </tr>
        <tr>
            <th>Rechnungsadresse Hausnummer</th>
            <td colspan="3"><?= $order->billing_house_number ?></td>
        </tr>
        <tr>
            <th colspan="4"><b>Zahlungsinformationen</b></th>
        </tr>
        <tr>
            <th>Rechnungsart</th>
            <td><?= $order->payment_method ?></td>
            <th>Konto Inhaber</th>
            <td><?= $order->account_owner ?></td>
        </tr>
        <tr>
            <th>IBAN</th>
            <td><?= $order->iban ?></td>
            <th>BIC</th>
            <td><?= $order->bic ?></td>
        </tr>
        <tr>
            <th>Bankname</th>
            <td colspan="3"><?= $order->bankname ?></td>
        </tr>
    </table>
</div>