<div class="wrap">
    <h1>{{ __('Create new price', LANG_DOMAIN) }}</h1>
    @if ($messages->isNotEmpty())
        <div id="message" class="updated notice is-dismissible">
            <p> <strong>{{ $messages->first() }}</strong></p>
            <button type="button" class="notice-dismiss">
                <span class="screen-reader-text">{{ __('Dismiss this message', LANG_DOMAIN) }}.</span>
            </button>
        </div>
    @endif
    @if ($errors->count() > 0)
        <div id="message" class="error notice is-dismissible">
            <p><strong>{{ __('Error while saving', LANG_DOMAIN) }}.</strong></p>
            <button type="button" class="notice-dismiss">
                <span class="screen-reader-text">{{ __('Dismiss this message', LANG_DOMAIN) }}.</span>
            </button>
        </div>
    @endif
    <form method="post" class="form-table wopp-admin-product--form">
        <table>
            <tr>
                <th>
                    <label class="row" for="is_blacklist">{{ __('Type', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <select id="is_blacklist" name="is_blacklist" style="{{ $errors->has('type') ? 'border: 1px solid red;' : '' }}">
                        <option value="1" {{ data_get($old, 'is_blacklist') == '1' ? 'selected' : '' }}>{{ __('Blacklist', LANG_DOMAIN) }}</option>
                        <option value="0" {{ data_get($old, 'is_blacklist') == '0' ? 'selected' : '' }}>{{ __('Whitelist', LANG_DOMAIN) }}</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="postcodes">{{ __('Postcodes', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="text" id="postcodes" name="postcodes" value="{{ data_get($old, 'postcodes') }}" style="{{ $errors->has('postcodes') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="networknumber">{{ __('Networknumber', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="text" id="networknumber" name="networknumber" value="{{ data_get($old, 'networknumber') }}" style="{{ $errors->has('networknumber') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="valid_from">{{ __('Valid from', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="date" id="valid_from" name="valid_from" value="{{ data_get($old, 'valid_from') }}" style="{{ $errors->has('valid_from') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="valid_to">{{ __('Valid to', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="date" id="valid_to" name="valid_to" value="{{ data_get($old, 'valid_to') }}" style="{{ $errors->has('valid_to') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="application_from">{{ __('Application from', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="date" id="application_from" name="application_from" value="{{ data_get($old, 'application_from') }}" style="{{ $errors->has('application_from') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="application_to">{{ __('Application to', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="date" id="application_to" name="application_to" value="{{ data_get($old, 'application_to') }}" style="{{ $errors->has('application_to') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="usage_from">{{ __('Usage from', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="number" id="usage_from" name="usage_from" value="{{ data_get($old, 'usage_from') }}" style="{{ $errors->has('usage_from') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="usage_to">{{ __('Usage to', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="number" id="usage_to" name="usage_to" value="{{ data_get($old, 'usage_to') }}" style="{{ $errors->has('usage_to') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="usage_price_et">{{ __('Usage price ET', LANG_DOMAIN) }} (ct)</label>
                </th>
                <td>
                    <input type="text" id="usage_price_et" name="usage_price_et" value="{{ data_get($old, 'usage_price_et') }}" style="{{ $errors->has('usage_price_et') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="usage_price_ht">{{ __('Usage price HT', LANG_DOMAIN) }} (ct)</label>
                </th>
                <td>
                    <input type="text" id="usage_price_ht" name="usage_price_ht" value="{{ data_get($old, 'usage_price_ht') }}" style="{{ $errors->has('usage_price_ht') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="usage_price_nt">{{ __('Usage price NT', LANG_DOMAIN) }} (ct)</label>
                </th>
                <td>
                    <input type="text" id="usage_price_nt" name="usage_price_nt" value="{{ data_get($old, 'usage_price_nt') }}" style="{{ $errors->has('usage_price_nt') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="base_price">{{ __('Base price', LANG_DOMAIN) }} (€)</label>
                </th>
                <td>
                    <input type="text" id="base_price" name="base_price" value="{{ data_get($old, 'base_price') }}" style="{{ $errors->has('base_price') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr class="wopp-admin-product--form--submit">
                <th>
                    <button type="submit" class="button button-primary">{{ __('Create price', LANG_DOMAIN) }}</button>
                </th>
            </tr>
        </table>
    </form>
</div>