<div class="wrap">
    <h1 class="wp-heading-inline">{{ __('Prices for', LANG_DOMAIN) }} {{ $product->name }}</h1>
    <a href="{{ menu_page_url('bew-prices-new', false) }}&id={{ $_GET['id'] }}" class="page-title-action">{{ __('Create price', LANG_DOMAIN) }}</a>

    <table class="wp-list-table widefat fixed striped products">
        <thead>
        <tr>
            <th>{{ __('Type', LANG_DOMAIN) }}</th>
            <th>{{ __('Postcodes', LANG_DOMAIN) }}</th>
            <th>{{ __('Networknumber', LANG_DOMAIN) }}</th>
            <th>{{ __('Valid from', LANG_DOMAIN) }}</th>
            <th>{{ __('Valid to', LANG_DOMAIN) }}</th>
            <th>{{ __('Application from', LANG_DOMAIN) }}</th>
            <th>{{ __('Application to', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage from', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage to', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price ET', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price HT', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price NT', LANG_DOMAIN) }}</th>
            <th>{{ __('Base price', LANG_DOMAIN) }}</th>
            <th>{{ __('Created at', LANG_DOMAIN) }}</th>
            <th>{{ __('Actions', LANG_DOMAIN) }}</th>
        </tr>
        </thead>
        <tbody>
        @foreach ($prices as $price)
            <tr>
                <td>{{ $price->is_blacklist ? __('Blacklist', LANG_DOMAIN) : __('Whitelist', LANG_DOMAIN) }}</td>
                <td>{{ $price->postcodes ?? 'k.A.' }}</td>
                <td>{{ $price->networknumber ?? 'k.A.' }}</td>
                <td>{{ format_date($price->valid_from) }}</td>
                <td>{{ format_date($price->valid_to) }}</td>
                <td>{{ format_date($price->application_from) }}</td>
                <td>{{ format_date($price->application_to) }}</td>
                <td>{{ $price->usage_from }}</td>
                <td>{{ $price->usage_to }}</td>
                <td>{{ number_format(round($price->usage_price_et * 100, 2), 2, ',', '.') }} ct</td>
                <td>{{ number_format(round($price->usage_price_ht * 100, 2), 2, ',', '.') }} ct</td>
                <td>{{ number_format(round($price->usage_price_nt * 100, 2), 2, ',', '.') }} ct</td>
                <td>{{ number_format(round($price->base_price, 2), 2, ',', '.') }} €</td>
                <td>{{ format_date($price->created_at) }}</td>
                <td>
                    <a href="{{ menu_page_url('bew-prices-destroy', false) }}&pid={{ $product->id }}&id={{ $price->id }}" target="_self">{{ __('Delete', LANG_DOMAIN) }}</a>
                </td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr>
            <th>{{ __('Type', LANG_DOMAIN) }}</th>
            <th>{{ __('Postcodes', LANG_DOMAIN) }}</th>
            <th>{{ __('Networknumber', LANG_DOMAIN) }}</th>
            <th>{{ __('Valid from', LANG_DOMAIN) }}</th>
            <th>{{ __('Valid to', LANG_DOMAIN) }}</th>
            <th>{{ __('Application from', LANG_DOMAIN) }}</th>
            <th>{{ __('Application to', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage from', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage to', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price ET', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price HT', LANG_DOMAIN) }}</th>
            <th>{{ __('Usage price NT', LANG_DOMAIN) }}</th>
            <th>{{ __('Base price', LANG_DOMAIN) }}</th>
            <th>{{ __('Created at', LANG_DOMAIN) }}</th>
            <th>{{ __('Actions', LANG_DOMAIN) }}</th>
        </tr>
        </tfoot>
    </table>
</div>
