<div class="wrap">
    <h1>{{ __('Product advantages', LANG_DOMAIN) }}</h1>

    @if ($messages->isNotEmpty())
        <div id="message" class="updated notice is-dismissible">
            <p> <strong>{{ $messages->first() }}</strong></p>
        </div>
    @endif
    @if ($errors->count() > 0)
        <div id="message" class="error notice is-dismissible">
            <p><strong>{{ __('Error while saving', LANG_DOMAIN) }}.</strong></p>
        </div>
    @endif

    <form method="post" class="form-table wopp-admin-advantage--form">
        <table width="100%">
            <tr class="input-group ">
                <th>
                    <label>{{ __('advantages', LANG_DOMAIN) }}</label>
                    <a href="javascript:;" id="add-advantage">{{ __('add', LANG_DOMAIN) }}</a>
                </th>
            </tr>
            @foreach ($old['id'] as $index => $id)
                <tbody class="advantage-group">
                <tr>
                    <input type="hidden" name="id[]" value="{{ $id }}">
                    <th>Vorteil</th>
                    <td>
                        <a href="javascript:;" class="remove-advantage">{{ __('Remove', LANG_DOMAIN) }}</a>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label class="row" for="key">{{ __('Key', LANG_DOMAIN) }} *</label>
                    </th>
                    <td>
                        <input required="" class="row" type="text" id="key" name="key[]" value="{{ data_get($old, 'key.'.$index) }}" style="<?= ($errors->has('key') ? 'border: 1px solid red;' : ''); ?>">
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="description">{{ __('Description', LANG_DOMAIN) }} *</label>
                    </th>
                    <td>
                        <textarea id="description" name="description[]" style="{{ $errors->has('description') ? 'border: 1px solid red;' : '' }}">{{ data_get($old, 'description.'.$index) }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td colspan="2"><hr/></td>
                </tr>
                </tbody>
            @endforeach

            <tfoot class="wopp-admin-advantage--form--submit">
                <tr >
                    <th>
                        <button type="submit" class="button button-primary">{{ __('Save advantages', LANG_DOMAIN) }}</button>
                    </th>
                </tr>
            </tfoot>
        </table>
    </form>
    <table id="template" style="display:none;">
        <tbody class="advantage-group" style="border:1px dashed black;">
            <tr>
                <input type="hidden" name="id[]" value="0" />
                <th>Vorteil</th>
                <td>
                    <a href="javascript:;" class="remove-advantage">{{ __('Remove', LANG_DOMAIN) }}</a>
                </td>
            </tr>
            <tr>
                <th>
                    <label class="row" for="key">Key *</label>
                </th>
                <td>
                    <input required="" class="row" type="text" id="key" name="key[]" value="" style="">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="description">{{ __('Description', LANG_DOMAIN) }} *</label>
                </th>
                <td>
                    <textarea id="description" name="description[]"></textarea>
                </td>
            </tr>
            <tr>
            <td colspan="2"><hr/></td>
            </tr>
        </tbody>
    </table>
</div>