<div class="wrap">
    <h1>{{ __('Edit product', LANG_DOMAIN) }} <i>{{ data_get($old, 'name') }}</i></h1>
    @if ($messages->isNotEmpty())
        <div id="message" class="updated notice is-dismissible">
            <p> <strong>{{ $messages->first() }}</strong></p>
            <button type="button" class="notice-dismiss">
                <span class="screen-reader-text">{{ __('Dismiss this message', LANG_DOMAIN) }}.</span>
            </button>
        </div>
    @endif
    @if ($errors->count() > 0)
        <div id="message" class="error notice is-dismissible">
            <p><strong>{{ __('Error while saving', LANG_DOMAIN) }}.</strong></p>
        </div>
    @endif

    <form method="post" class="form-table wopp-admin-product--form">
        <table width="75%">
            <tr>
                <th>
                    <label class="row" for="name">{{ __('Name', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input class="row" type="text" id="name" name="name" value="{{ data_get($old, 'name') }}" style="{{ $errors->has('name') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="energy_type">{{ __('Energytype', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <select id="energy_type" name="energy_type" style="{{ $errors->has('energy_type') ? 'border: 1px solid red;' : '' }}">
                        <option value="power" {{ data_get($old, 'energy_type') == 'power' ? 'selected' : '' }}>{{ __('Power', LANG_DOMAIN) }}</option>
                        <option value="gas" {{ data_get($old, 'energy_type') == 'gas' ? 'selected' : '' }}>{{ __('Gas', LANG_DOMAIN) }}</option>
                        <option value="heat" {{ data_get($old, 'energy_type') == 'heat' ? 'selected' : '' }}>{{ __('Distance heating', LANG_DOMAIN) }}</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="external_key">{{ __('External key', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="text" id="external_key" name="external_key" value="{{ data_get($old, 'external_key') }}" style="{{ $errors->has('external_key') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="description">{{ __('Description', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    @php
                        wp_editor(data_get($old, 'description'), 'description', [
                            'media_buttons' => false,
                            'textarea_name' => 'description',
                            'teeny' => true,
                            'quicktags' => [
                                'buttons' => 'strong,em,ul,ol,li,close,spell'
                            ],
                            'tinymce' => [
                                'menubar' => 'edit view format table',
                                'toolbar' => 'bold, italic, underline, strikethrough, alignleft, aligncenter, alignright, alignjustify, styleselect, formatselect, fontselect, fontsizeselect, cut, copy, paste, bullist, numlist, outdent, indent, blockquote, undo, redo, removeformat, subscript, superscript',
                                'fontsize_formats' => '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
                                'plugins' => 'table wordcount code',
                            ]
                        ]);
                    @endphp
                </td>
            </tr>
            <tr>
                <th>
                    <label for="is_active">{{ __('Active', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="hidden" name="is_active" value="0">
                    <input type="checkbox" id="is_active" name="is_active" value="1" style="{{ $errors->has('is_active') ? 'border: 1px solid red;' : '' }}" {{ data_get($old, 'is_active') == '1' ? 'checked' : '' }}>
                </td>
            </tr>
            <tr class="file_row">
                <th>
                    <label>{{ __('Icon') }}</label>
                </th>
                <td>
                    <div style="width:90%; float:right;">
                        @php ($icon = new stdClass())
                        @if (array_get($old, 'icon_id'))
                            @php($icon = WP_Post::get_instance(array_get($old, 'icon_id')))
                        @endif
                        <input type="text" class="image-select" value="{{ $icon->post_title }}" readonly="" data-media="product-icon" data-media-attr="title"  style="width:100%; {{ $errors->has('icon_id') ? 'border: 1px solid red;' : '' }}">
                        <input type="hidden" name="icon_id" value="{{ array_get($old, 'icon_id') }}" data-media="product-icon" data-media-attr="id">
                    </div>
                    <div style="width:10%;">
                        <a href="javascript:;" class="image-select button" data-media-target="product-icon">{{ __('Choose', LANG_DOMAIN) }}</a>
                    </div>
                </td>
            </tr>
            <tr class="input-group ">
                <th>
                    <label for="file">{{ __('Files', LANG_DOMAIN) }}</label>
                    <a href="javascript:;" id="add-file">{{ __('Add', LANG_DOMAIN) }}</a>
                </th>
            </tr>
            @if (array_has($old, 'file'))
                @foreach (array_get($old, 'file') as $index => $value)
                    @php($post = WP_Post::get_instance($value))
                @endforeach

                <tr class="file_row">
                    <td width="33%">
                        <a href="javascript:;" class="media-select" data-media-target="product-files">{{ __('Choose', LANG_DOMAIN) }}</a>&nbsp;|&nbsp;<a href="javascript:;" class="remove-file-link">{{ __('Remove', LANG_DOMAIN) }}</a>
                    </td>
                    <td width="45%">
                        <input type="text" class="media-select" value="{{ $post->post_title }}" readonly="" data-media="product-files" data-media-attr="title"  style="width:100%; {{ $errors->has('file.'.$index) ? 'border: 1px solid red;' : '' }}">
                        <input type="hidden" name="file[]" value="{{ $value }}" data-media="product-files" data-media-attr="id">
                    </td>
                    <td width="21%">
                        <select name="file_type[]" style="{{ $errors->has('file_type.'.$index) ? 'border: 1px solid red;' : '' }}">
                            <option value="tos" {{ data_get($old, 'file_type.'.$index) == 'tos' ? 'selected' : '' }}>{{ __('TOS', LANG_DOMAIN) }}</option>
                            <option value="pricefile" {{ data_get($old, 'file_type.'.$index) == 'pricefile' ? 'selected' : '' }}>{{ __('Pricefile', LANG_DOMAIN) }}</option>
                            <option value="other" {{ data_get($old, 'file_type.'.$index) == 'other' ? 'selected' : '' }}>{{ __('Other', LANG_DOMAIN) }}</option>
                        </select>
                    </td>
                </tr>
            @endif
            <tr class="wopp-admin-product--form--submit">
                <th>
                    <button type="submit" class="button button-primary">{{ __('Update product', LANG_DOMAIN) }}</button>
                </th>
            </tr>
        </table>
    </form>
    <table id="template" style="display:none;">
        <tr class="file_row" style="display:none;">
            <td width="33%">
                <a href="javascript:;" class="media-select" data-media-target="product-files">{{ __('Choose', LANG_DOMAIN) }}</a>&nbsp;|&nbsp;<a href="javascript:;" class="remove-file-link">{{ __('Remove', LANG_DOMAIN) }}</a>
            </td>
            <td width="45%">
                <input type="text" class="media-select" value="" readonly="" data-media="product-files" data-media-attr="title" style="width:100%;">
                <input type="hidden" name="file[]" value="" data-media="product-files" data-media-attr="id">
            </td>
            <td width="21%">
                <select name="file_type[]">
                    <option value="tos" {{ data_get($old, 'file_type') == 'tos' ? 'selected' : '' }}>{{ __('TOS', LANG_DOMAIN) }}</option>
                    <option value="pricefile" {{ data_get($old, 'file_type') == 'pricefile' ? 'selected' : '' }}>{{ __('Pricefile', LANG_DOMAIN) }}</option>
                    <option value="other" {{ data_get($old, 'file_type') == 'other' ? 'selected' : '' }}>{{ __('Other', LANG_DOMAIN) }}</option>
                </select>
            </td>
        </tr>
    </table>
</div>
