<div class="wrap">
    <h1 class="wp-heading-inline">{{ __('Products', LANG_DOMAIN) }}</h1>
    <a href="{{ menu_page_url('bew-products-new', false) }}" class="page-title-action">{{ __('Create new', LANG_DOMAIN) }}</a>

    <table class="wp-list-table widefat fixed striped products">
        <thead>
            <tr>
                <th>{{ __('Name', LANG_DOMAIN) }}</th>
                <th>{{ __('Energytype', LANG_DOMAIN) }}</th>
                <th>{{ __('External key', LANG_DOMAIN) }}</th>
                <th>{{ __('Active', LANG_DOMAIN) }}</th>
                <th>{{ __('Created at', LANG_DOMAIN) }}</th>
                <th>{{ __('Last edited', LANG_DOMAIN) }}</th>
                <th>{{ __('Actions', LANG_DOMAIN) }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($products as $product)
                <tr>
                    <td>{{ $product->name }}</td>
                    <td>{{ format_energy_type($product->energy_type) }}</td>
                    <td>{{ $product->external_key }}</td>
                    <td>{{ $product->is_active == '1' ? 'Ja' : 'Nein' }}</td>
                    <td>{{ format_date($product->created_at, 'd.m.Y H:i:s') }}</td>
                    <td>{{ format_date($product->updated_at, 'd.m.Y H:i:s') }}</td>
                    <td>
                        <a href="{{ menu_page_url('bew-product-advantages', false) }}&id={{ $product->id }}" target="_self">{{ __('Advantages', LANG_DOMAIN) }}</a> |
                        <a href="{{ menu_page_url('bew-products-edit', false) }}&id={{ $product->id }}" target="_self">{{ __('Edit', LANG_DOMAIN) }}</a> |
                        <a href="{{ menu_page_url('bew-products-destroy', false) }}&id={{ $product->id }}" target="_self">{{ __('Delete', LANG_DOMAIN) }}</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th>{{ __('Name', LANG_DOMAIN) }}</th>
                <th>{{ __('Energytype', LANG_DOMAIN) }}</th>
                <th>{{ __('External key', LANG_DOMAIN) }}</th>
                <th>{{ __('Active', LANG_DOMAIN) }}</th>
                <th>{{ __('Created at', LANG_DOMAIN) }}</th>
                <th>{{ __('Last edited', LANG_DOMAIN) }}</th>
                <th>{{ __('Actions', LANG_DOMAIN) }}</th>
            </tr>
        </tfoot>
    </table>
</div>
