<?php

/*
Plugin Name: booyah Products, Prices and Orders
Plugin URI: http://beispiel.de/plugins/mein-plugin
Description: Wordpress Plugin for energy products, prices and orders
Version: 0.0.1
Author: REDTREE GmbH
Author URI: https://www.booyah.cloud
License: proprietary
Text Domain: wordpres-order-products-prices
Domain Path: /languages
*/
defined('ABSPATH') or die('Oh you!');

use booyah\WOPP\Administration\Menu;
use booyah\WOPP\Install\Installation;
use booyah\WOPP\Services\OrderExport;
use Jenssegers\Blade\Blade;

require_once 'vendor/autoload.php';
require_once ABSPATH . 'wp-admin/includes/upgrade.php';
require_once ABSPATH . 'wp-admin/includes/plugin.php';

$bladeViews = ABSPATH . 'wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/views/';
$bladeViewsCache = ABSPATH . 'wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/cache/views/';

if (! is_dir($bladeViewsCache)) {
    mkdir($bladeViewsCache, 0777, true);
}

global $woppBlade;
$woppBlade = new Blade([$bladeViews], $bladeViewsCache);

define('LANG_DOMAIN', 'wordpres-order-products-prices');
define('WOPP_CURRENT_VERSION', '0.0.1');

if (! class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

function bew_wopp_check_admin_plugin()
{
    if (! is_plugin_active('bew-admin/bew-admin.php')) {
        die('booyah Energy Webshop '.__('plugin missing'));
    }
}

function wopp_activation_hook()
{
    bew_wopp_check_admin_plugin();
    Installation::run();
}

register_activation_hook(__FILE__, 'wopp_activation_hook');


/** Step 1. */
function wopp_plugin_menu()
{
    Menu::create();
}

add_action('admin_menu', 'wopp_plugin_menu');

add_action('admin_init', 'orders_export_download');

function orders_export_download()
{
    if (isset($_GET['page']) && $_GET['page'] == 'bew-orders-export-download') {
        $delimiter = ',';
        $enclosure = ',';

        switch ($_POST['delimiter']) {
            case '1':
                $delimiter = ',';
                break;
            case '2':
                $delimiter = ';';
                break;
        }

        switch ($_POST['enclosure']) {
            case '1':
                $enclosure = '"';
                break;
            case '2':
                $enclosure = '\'';
                break;
        }

        $export = new OrderExport();

        if (isset($_POST['products'])) {
            $export->setProducts($_POST['products']);
        }

        $export->setOptions($delimiter, $enclosure)->export();
        die;
    }
}

add_action('admin_init', function () {
    wp_register_script('wopp-admin', plugin_dir_url(__FILE__).'/js/wopp-admin.js', [], null);
    wp_enqueue_media();
    wp_enqueue_script('wopp-admin');
});

function booyah_wopp_load_plugin_textdomain()
{
    load_plugin_textdomain(LANG_DOMAIN, false, basename(dirname(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'booyah_wopp_load_plugin_textdomain');

add_action('tgmpa_register', function () {
    $plugins = [
        [
            'required' => true,
            'name' => 'Booyah Energy Webshop - Admin',
            'slug' => 'bew-admin',
            'force_activation' => true,
        ],
    ];
    $config = [
        'id' => 'booyah',
        'dismissable' => false,
    ];
    tgmpa($plugins, $config);
});


// Cronjobs
//register_deactivation_hook(__FILE__, 'booyah_wopp_license_check_deactivate');

function booyah_wopp_license_check_deactivate()
{
    $timestamp = wp_next_scheduled('booyah_wopp_license_check');
    wp_unschedule_event($timestamp, 'booyah_wopp_license_check');
}

function booyah_wopp_license_check()
{
    //License
    $options = get_option('booyah_wopp_settings');

    return booyah_bew_admin_licensing_validation('plugin', LANG_DOMAIN, array_get($options, 'license.key', ''), WOPP_CURRENT_VERSION);
}


if (! function_exists('booyah_wopp_calculator_settings')) {
    function booyah_wopp_calculator_settings($key = null)
    {
        $options = get_option('booyah_wopp_order_settings');
        if (! is_null($key)) {
            return array_get($options, 'calculator.'.$key);
        }

        return array_get($options, 'calculator', []);
    }
}
