<?php

namespace booyah\WOPP\Administration\Controller;

use booyah\WOPP\Helpers\Collection;
use booyah\WOPP\Models\Order;
use booyah\WOPP\Models\Product;
use booyah\WOPP\Services\OrderValidationService;

class OrderController
{
    public static function index()
    {
        $orders = Order::all();

        view('orders.index', compact('orders'));
    }

    public static function show()
    {
        $order = Order::find($_GET['id'] ?? null);

        if ($order === null) {
            die(__('Orders not found', LANG_DOMAIN));
        }

        $product = Product::find($order->product_id);

        view('orders.show', compact('product', 'order'));
    }

    public static function export()
    {
        $products = Product::all();

        view('orders.export', compact('products'));
    }

    public static function settings()
    {
        $old = get_option('wopp_order_settings') ?? [];
        $errors = new Collection();
        $messages = new Collection();

        $validated = (new OrderValidationService())
        ->setFields(['payment_method', 'order_type', 'salutation'])
        ->setData([
            'payment_method' => 'sepa',
            'order_type' => 'change',
            'desired_at' => '2018-09-12',
            'shipping_postcode' => '43214',
        ])
        ->validate();


        if (is_post_request()) {
            $rules = [
                /*
                'calculator' => ['required', 'array'],
                'calculator.private' => ['required', 'array'],
                'calculator.business' => ['required', 'array'],
                'calculator.*.gas' => ['required', 'array'],
                'calculator.*.power' => ['required', 'array'],
                'calculator.*.*.min' => ['required', 'integer'],
                'calculator.*.*.max' => ['required', 'integer'],
                'calculator.private.*.steps.single' => ['required', 'integer'],
                'calculator.private.*.steps.couple' => ['required', 'integer'],
                'calculator.private.*.steps.small' => ['required', 'integer'],
                'calculator.private.*.steps.family' => ['required', 'integer'],
                'calculator.business.*.steps.small' => ['required', 'integer'],
                'calculator.business.*.steps.medium' => ['required', 'integer'],
                'calculator.business.*.steps.big' => ['required', 'integer'],
                'calculator.business.*.steps.large' => ['required', 'integer'],
                */
                'change' => ['required', 'array'],
                'change.movement.days' => ['required', 'integer', 'min:42'],
                'change.supplier.type' => ['required', 'in:fix,free'],
                'change.supplier.add' => ['required', 'integer'],
                'change.supplier.add-type' => ['required', 'in:days,weeks,months'],
                'change.supplier.*' => ['required_if:change.supplier.type,fix'],
            ];
            $options = cast_and_sanitize($_POST);
            $validator = bew_admin_validator($options, $rules);
            if ($validator->fails()) {
                $errors = $validator->errors();
            } else {
                update_option('wopp_order_settings', $options);
                $messages->push(__('Settings saved', LANG_DOMAIN));
            }

            $old = $options;
        }

        view('orders.settings.settings', compact('old', 'errors', 'messages'));
    }

    public static function fieldSettings()
    {
        $messages = new Collection();
        $orderFields = bew_orders_get_field();

        if (is_post_request()) {
            $post = collect($_POST);

            foreach ($post->get('show') as $key => $value) {
                data_set($orderFields, $key . '.show', (bool) $value);
            }
            foreach ($post->get('active') as $key => $value) {
                data_set($orderFields, $key . '.is_active', (bool) $value);
            }
            foreach ($post->get('required') as $key => $value) {
                data_set($orderFields, $key . '.is_required', (bool) $value);
            }
            foreach ($post->get('options') as $key => $values) {
                foreach ($values as $optionKey => $value) {
                    data_set($orderFields, $key . '.options.' . $optionKey . '.is_active', (bool) $value);
                }
            }

            $messages->push((update_option('wopp_order_fields', $orderFields) ? __('Fields saved') : __('Fields could not be saved')) . '.');
        }

        $orderFields = collect($orderFields);

        view('orders.settings.fields', compact('messages', 'orderFields'));
    }
}
