<?php

namespace booyah\WOPP\Administration\Controller;

use booyah\WOPP\Helpers\Collection;
use booyah\WOPP\Models\Price;
use booyah\WOPP\Models\Product;

class PriceController
{
    public static function index()
    {
        $products = Product::all();

        view('prices.index', compact('products'));
    }

    public static function show()
    {
        $product = Product::find($_GET['id'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN));
        }

        $prices = Price::where('product_id', $product->id)->get();

        view('prices.show', compact('product', 'prices'));
    }

    public static function create()
    {
        $old = [];
        $errors = new Collection();
        $messages = new Collection();

        $product = Product::find($_GET['id'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN));
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $validation = bew_admin_validator($_POST, [
                'is_blacklist' => ['required', 'in:0,1'],
                'valid_from' => ['required', 'date'],
                'valid_to' => ['required', 'date'],
                'application_from' => ['required', 'date'],
                'application_to' => ['required', 'date'],
                'usage_from' => ['required', 'integer'],
                'usage_to' => ['required', 'integer'],
                'base_price' => ['required'],
            ]);

            $data = cast_and_sanitize($_POST);
            $data = array_filter($data, function($val) {
                if(is_numeric($val)) {

                    return true;
                }

                return ! empty(trim($val));
            });

            if ($validation->fails()) {
                $old = $data;
                $errors = $validation->errors();
            } else {
                if (! empty($data['usage_price_et'])) {
                    $data['usage_price_et'] = ((float) str_replace(',', '.', $data['usage_price_et'])) / 100;
                }
                if (! empty($data['usage_price_ht'])) {
                    $data['usage_price_ht'] = ((float) str_replace(',', '.', $data['usage_price_ht'])) / 100;
                }
                if (! empty($data['usage_price_nt'])) {
                    $data['usage_price_nt'] = ((float) str_replace(',', '.', $data['usage_price_nt'])) / 100;
                }

                $price = new Price();
                $price->product_id = $product->id;
                $price->update($data);

                $messages->push(__('Price created', LANG_DOMAIN) . '.');
            }
        }

        if (empty($old) && isset($_GET['did'])) {
            $duplicate = Price::find($_GET['did']);
            if (! is_null($duplicate)) {
                $old = $duplicate->getAttributes();
                if (trim(array_get($old, 'application_to')) !== '') {
                    $old['application_to'] = explode(' ', $old['application_to'])[0];
                }
                if (trim(array_get($old, 'application_to')) !== '') {
                    $old['application_from'] = explode(' ', $old['application_from'])[0];
                }
                if (trim(array_get($old, 'application_to')) !== '') {
                    $old['valid_to'] = explode(' ', $old['valid_to'])[0];
                }
                if (trim(array_get($old, 'application_to')) !== '') {
                    $old['valid_from'] = explode(' ', $old['valid_from'])[0];
                }
            }
        }

        view('prices.create', compact('old', 'errors', 'messages', 'product'));
    }

    public static function destroy()
    {
        $product = Product::find($_GET['pid'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN));
        }

        $price = Price::where('product_id', $_GET['pid'])->find($_GET['id'] ?? null);

        if ($price === null) {
            die(__('Price not found', LANG_DOMAIN));
        }

        if ($price->delete()) {
            echo __('Price deleted', LANG_DOMAIN) . '.';
        } else {
            echo __('Could not delete price', LANG_DOMAIN) . '.';
        }
    }
}
