<?php

namespace booyah\WOPP\Administration\Controller;

use booyah\WOPP\Helpers\Collection;
use booyah\WOPP\Models\Advantage;
use booyah\WOPP\Models\Product;

class ProductController
{
    public static function index()
    {
        $products = Product::all();

        view('products.index', compact('products'));
    }

    public static function create()
    {
        $old = [];
        $errors = new Collection();
        $messages = new Collection();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $validation = bew_admin_validator($_POST, [
                'name' => ['required'],
                'energy_type' => ['required', 'in:power,gas,heat'],
                'external_key' => ['required'],
                'icon_id' => ['required', 'min:1'],
                'slogan_priceshow' => ['required', 'min:5'],
                'slogan_contract' => ['required', 'min:5'],
                'contract_period' => ['required', 'integer', 'min:1', ],
                'contract_period_type' => ['required', 'in:months,years'],
                'price_warranty' => ['required', 'integer', 'min:0', ],
                'price_warranty_type' => ['required', 'in:months,years'],
                'file' => ['required_with:file_type', 'array'],
                'file.*' => ['required', 'numeric'],
                'file_type' => ['required_with:file', 'array'],
                'file_type.*' => ['required', 'in:tos,pricefile,other'],
            ]);

            $data = $_POST;

            if ($validation->fails()) {
                $old = $data;
                $errors = $validation->errors();
            } else {
                $product = new Product();
                $product->created_by = wp_get_current_user()->ID;
                $product->update($data);
                $files = [];

                foreach (array_get($data, 'file', []) as $index => $id) {
                    if (empty($id)) {
                        continue;
                    }
                    $files[] = [
                        'id' => $id,
                        'type' => array_get($data, 'file_type.'.$index, [])
                    ];
                }
                $product->syncMedias($files);

                $messages->push(__('Product created', LANG_DOMAIN) . '.');
            }
        }

        view('products.create', compact('old', 'errors', 'messages'));
    }

    public static function edit()
    {
        $product = Product::find($_GET['id'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN));
        }

        $old = $product->toArray();
        $errors = new Collection();
        $messages = new Collection();

        $old['file'] = [];
        $old['file_type'] = [];

        foreach ($product->medias as $media) {
            $old['file'][] = $media->media_id;
            $old['file_type'][] = $media->media_type;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $old = $_POST;

            $validation = bew_admin_validator($old, [
                'name' => ['required'],
                'energy_type' => ['required', 'in:power,gas,heat'],
                'external_key' => ['required'],
                'slogan_priceshow' => ['required', 'min:5'],
                'slogan_contract' => ['required', 'min:5'],
                'contract_period' => ['required', 'integer', 'min:1', ],
                'contract_period_type' => ['required', 'in:months,years'],
                'price_warranty' => ['required', 'integer', 'min:0', ],
                'price_warranty_type' => ['required', 'in:months,years'],
                'icon_id' => ['required', 'min:1'],
                'file' => ['required_with:file_type', 'array'],
                'file.*' => ['required', 'numeric'],
                'file_type' => ['required_with:file', 'array'],
                'file_type.*' => ['required', 'in:tos,pricefile,other'],
            ]);

            if ($validation->fails()) {
                $errors = $validation->errors();
            } else {
                $product->update($old);
                $files = [];

                foreach (array_get($old, 'file', []) as $index => $id) {
                    if (empty($id)) {
                        continue;
                    }
                    $files[] = [
                        'id' => $id,
                        'type' => array_get($old, 'file_type.'.$index, [])
                    ];
                }
                $product->syncMedias($files);
                $messages->push(__('Product saved', LANG_DOMAIN));
            }
        }

        view('products.edit', compact('old', 'errors', 'messages'));
    }

    /**
     * @throws \Exception
     */
    public static function destroy()
    {
        $product = Product::find($_GET['id'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN) . '.');
        }

        if ($product->delete()) {
            echo __('Product deleted', LANG_DOMAIN) . '.';
        } else {
            echo __('Could not delete product', LANG_DOMAIN) . '.';
        }
    }

    public static function advantages()
    {
        $product = Product::find($_GET['id'] ?? null);

        if ($product === null) {
            die(__('Product not found', LANG_DOMAIN) . '.');
        }

        $old = [
            'id' => [],
            'key' => [],
            'description' => [],
        ];

        $errors = new Collection();
        $messages = new Collection();

        $product->advantages->each(function ($advantage) use (&$old) {
            $old['id'][] = $advantage->id;
            $old['key'][] = $advantage->key;
            $old['description'][] = $advantage->description;
        });

        if (is_post_request()) {
            $rules = [
                'id' => ['required_with:key', 'array'],
                'key' => ['required_with:id', 'array'],
                'description' => ['required_with:id', 'array'],
                'key.*' => ['required', 'max:20'],
                'description.*' => ['required', 'max:55'],
            ];

            $validation = bew_admin_validator($_POST, $rules);

            if ($validation->fails()) {
                $errors = $validation->errors();
                $old = $_POST;
            } else {
                $data = cast_and_sanitize($_POST);
                $advantages = $product->advantages;

                foreach (array_get($data, 'id') as $index => $id) {
                    if ($id > 0) {
                        $object = Advantage::find($id);
                    } else {
                        $object = new Advantage();
                    }

                    $attributes = [
                        'product_id' => $product->id,
                        'key' => array_get($data, 'key.'.$index),
                        'description' => array_get($data, 'description.'.$index),
                    ];

                    $object->fill($attributes)->save();
                }

                $ids = array_where($data['id'], function ($id) {
                    return $id > 0;
                });

                $toDetach = $advantages->filter(function ($advantage) use ($ids) {
                    return ! in_array($advantage->id, $ids);
                });

                foreach ($toDetach as $advantage) {
                    $advantage->delete();
                }

                $old = [];

                $product->advantages->each(function ($advantage) use (&$old) {
                    $old['id'][] = $advantage->id;
                    $old['key'][] = $advantage->key;
                    $old['description'][] = $advantage->description;
                });

                $messages->push(__('Advantages saved', LANG_DOMAIN) . '.');
            }
        }

        view('products.advantage', compact('old', 'errors', 'messages'));
    }
}
