<?php

namespace booyah\WOPP\Administration\Controller;

use booyah\WOPP\Helpers\Collection;

class SettingsController
{
    public static function index()
    {
        $options = get_option('booyah_wopp_settings') ?: [];
        $errors = new Collection();
        $old = $options;
        if (is_post_request()) {
            switch (array_get($_POST, 'action')) {
                case 'update':
                    $url = booyah_bew_admin_licensing_update_url('plugin', LANG_DOMAIN, array_get($options, 'license.key', ''), WOPP_CURRENT_VERSION);
                    if (! $url) {
                        break;
                    }
                    $success = booyah_bew_admin_update(LANG_DOMAIN, ['url' => $url]);
                    if ($success) {
                        $options['has_updates'] = false;
                        update_option('booyah_wopp_settings', $options, false);
                    }
                    break;
                case 'options':
                    $casted = cast_and_sanitize($_POST);
                    $key = array_get($casted, 'key');
                    $valid = booyah_bew_admin_licensing_validation('plugin', LANG_DOMAIN, $key, WOPP_CURRENT_VERSION);
                    if (! $valid) {
                        $errors = new Collection([
                            'key' => [
                                'Invalid key',
                            ],
                        ]);
                        $old['license']['key'] = $key;
                    } else {
                        $options['license']['key'] = $key;
                        update_option('booyah_wopp_settings', $options, false);
                        $old = $options;
                    }
                case 'check':
                    $hasUpdate = booyah_bew_admin_licensing_check_for_update('plugin', LANG_DOMAIN, $key, WOPP_CURRENT_VERSION);
                    $options['has_updates'] = $hasUpdate;
                    update_option('booyah_wopp_settings', $options, false);
                    $old = $options;
            }
        }

        return view('settings.index', compact('old', 'options', 'errors'));
    }
}
