<?php

namespace booyah\WOPP\Administration;

class Menu
{
    public static function create()
    {
        $instance = new static();
        $instance->build();
    }

    public function build()
    {
        $this->createSettingsMenu();
        // Needs to be enabled as soon as we have licensing
        // if (booyah_wopp_plugin_enabled()) {
        $this->createProductsMenu();
        $this->createPricesMenu();
        $this->createOrdersMenu();
        // }
    }

    public function createSettingsMenu()
    {
        add_submenu_page(
            'bew-admin',
            'booyah Webshop ' . __('Products and orders settings', LANG_DOMAIN), // page_title
            __('Products and Order Settings', LANG_DOMAIN), // menu_title
            'booyah_super_admin', // capability
            'bew-wopp-update', // menu_slug
            'booyah\\WOPP\\Administration\\Controller\\SettingsController::index' // function
        );
    }

    public function createProductsMenu()
    {
        add_menu_page(
            'booyah Webshop ' . __('Products', LANG_DOMAIN), // page_title
            __('Products', LANG_DOMAIN), // menu_title
            'booyah_read_products', // capability
            'bew-products', // menu_slug
            'booyah\\WOPP\\Administration\\Controller\\ProductController::index', // function
            'dashicons-products', // icon
            null // position
        );

        add_submenu_page(
            'bew-products',
            'booyah Webshop ' . __('products', LANG_DOMAIN),
            __('All Products', LANG_DOMAIN),
            'booyah_read_products',
            'bew-products'
        );

        add_submenu_page(
            'bew-products',
            'booyah Webshop ' . __('create product', LANG_DOMAIN),
            __('Create', LANG_DOMAIN),
            'booyah_add_products',
            'bew-products-new',
            'booyah\\WOPP\\Administration\\Controller\\ProductController::create' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('edit product', LANG_DOMAIN),
            null,
            'booyah_edit_products',
             'bew-products-edit',
            'booyah\\WOPP\\Administration\\Controller\\ProductController::edit' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('delete product', LANG_DOMAIN),
            null,
            'booyah_delete_products',
             'bew-products-destroy',
            'booyah\\WOPP\\Administration\\Controller\\ProductController::destroy' // function
        );
        add_submenu_page(
            'bew-products',
            'booyah Webshop ' . __('product advantages', LANG_DOMAIN),
            null,
            'booyah_edit_products',
             'bew-product-advantages',
            'booyah\\WOPP\\Administration\\Controller\\ProductController::advantages' // function
        );
    }

    public function createPricesMenu()
    {
        add_menu_page(
            'booyah Webshop ' . __('prices', LANG_DOMAIN), // page_title
            __('Prices', LANG_DOMAIN), // menu_title
            'booyah_read_prices', // capability
            'bew-prices', // menu_slug
            'booyah\\WOPP\\Administration\\Controller\\PriceController::index', // function
            'dashicons-media-spreadsheet', // icon
            null // position
        );

        add_submenu_page(
            'bew-prices',
            'booyah Webshop ' . __('prices', LANG_DOMAIN),
            __('All prices', LANG_DOMAIN),
            'booyah_read_prices',
            'bew-prices'
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('prices', LANG_DOMAIN),
            null,
            'booyah_read_prices',
            'bew-prices-show',
            'booyah\\WOPP\\Administration\\Controller\\PriceController::show' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('create price', LANG_DOMAIN),
            null,
            'booyah_add_prices',
            'bew-prices-new',
            'booyah\\WOPP\\Administration\\Controller\\PriceController::create' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('delete price', LANG_DOMAIN),
            null,
            'booyah_delete_prices',
            'bew-prices-destroy',
            'booyah\\WOPP\\Administration\\Controller\\PriceController::destroy' // function
        );
    }

    public function createOrdersMenu()
    {
        add_menu_page(
            'booyah Webshop ' . __('orders', LANG_DOMAIN), // page_title
            __('Orders', LANG_DOMAIN), // menu_title
            'booyah_read_orders', // capability
            'bew-orders', // menu_slug
            'booyah\\WOPP\\Administration\\Controller\\OrderController::index', // function
            'dashicons-cart', // icon
            null // position
        );

        add_submenu_page(
            'bew-orders',
            'booyah Webshop ' . __('orders', LANG_DOMAIN),
            __('All orders', LANG_DOMAIN),
            'booyah_read_orders',
            'bew-orders'
        );

        add_submenu_page(
            'bew-orders',
            'booyah Webshop ' . __('Fieldsettings', LANG_DOMAIN),
            __('Fieldsettings', LANG_DOMAIN),
            'manage_options',
            'bew-orders-field-settings',
            'booyah\\WOPP\\Administration\\Controller\\OrderController::fieldSettings' // function
        );

        add_submenu_page(
            'bew-orders',
            'booyah Webshop ' . __('order settings', LANG_DOMAIN),
            __('Settings', LANG_DOMAIN),
            'booyah_edit_orders_settings',
            'bew-orders-settings',
            'booyah\\WOPP\\Administration\\Controller\\OrderController::settings' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('order', LANG_DOMAIN),
            null,
            'booyah_read_orders',
            'bew-orders-show',
            'booyah\\WOPP\\Administration\\Controller\\OrderController::show' // function
        );

        add_submenu_page(
            'bew-orders',
            'booyah Webshop ' . __('order export', LANG_DOMAIN),
            __('Export', LANG_DOMAIN),
            'booyah_export_orders',
            'bew-orders-export',
            'booyah\\WOPP\\Administration\\Controller\\OrderController::export' // function
        );

        add_submenu_page(
            null,
            'booyah Webshop ' . __('order export', LANG_DOMAIN),
            null,
            'booyah_export_orders',
            'bew-orders-export-download',
            null// function
        );
    }
}
