<?php

namespace booyah\WOPP\Models;

use booyah\WOPP\Models\Traits\SoftDeletes;

class Order extends Model
{
    use SoftDeletes;

    protected $table = 'orders';

    protected $fillable = [
        'product_id',
        'usage_price_et',
        'usage_price_ht',
        'usage_price_nt',
        'base_price',
        'usage',
        'usage_nt',
        'vat',
        'networknumber',
        'customer_type',
        'first_name',
        'last_name',
        'salutation',
        'title',
        'birthday',
        'phone_number',
        'email',
        'order_type',
        'meter_number',
        'previous_supplier_id',
        'previous_supplier_code',
        'previous_supplier_name',
        'previous_supplier_customer_number',
        'desired_at',
        'is_cancelled',
        'cancelled_at',
        'moving_in_at',
        'reading_at',
        'meter_reading',
        'shipping_postcode',
        'shipping_city',
        'shipping_street',
        'shipping_house_number',
        'billing_address_different',
        'billing_first_name',
        'billing_last_name',
        'billing_postcode',
        'billing_city',
        'billing_street',
        'billing_house_number',
        'moving_previous_street',
        'moving_previous_house_number',
        'moving_previous_postcode',
        'moving_previous_city',
        'payment_method',
        'account_owner',
        'iban',
        'bic',
        'direct_debit',
        'tos',
        'mandate',
        'revocation',
        'newsletter',
        'bankname',
        'exported_at',
    ];

    protected $casts = [
        'is_cancelled' => 'bool',
    ];
}
