<?php

namespace booyah\WOPP\Models;

use booyah\WOPP\Helpers\Collection;
use booyah\WOPP\Models\Traits\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;

    protected $table = 'products';

    protected $fillable = [
        'created_by',
        'energy_type',
        'name',
        'external_key',
        'slogan_priceshow',
        'additional_info',
        'slogan_contract',
        'is_active',
        'exclude_from_recommendations',
        'only_existing_customers',
        'customer_type',
        'description',
        'price_warranty',
        'price_warranty_type',
        'price_warranty_fixed',
        'contract_period',
        'contract_period_type',
        'icon_id',
    ];

    protected $casts = [
        'is_active' => 'bool',
        'exclude_from_recommendations' => 'bool',
        'only_existing_customers' => 'bool',
    ];

    public function medias()
    {
        $id = $this->id;

        return MediaProduct::whereProductId($id);
    }

    /**
     * @return Advantage
     */
    public function advantages()
    {
        return Advantage::whereProductId($this->id);
    }

    /**
     * @return Collection
     */
    public function getAdvantagesAttribute()
    {
        return $this->advantages()->get();
    }

    /**
     * @return Collection
     */
    public function getMediasAttribute()
    {
        return $this->medias()->get();
    }

    public function getMediaPostAttribute()
    {
        $result = new Collection();
        $this->medias->pluck('media_id')->each(function ($id) use ($result) {
            $result->push(\WP_Post::get_instance($id));
        });

        return $result;
    }

    public function syncMedias(array $medias)
    {
        $ids = array_pluck($medias, 'id');
        $mediaOrginial = $this->medias;
        $mediaOrginialGrouped = $mediaOrginial->groupBy('media_id');
        foreach ($medias as $media) {
            $id = array_get($media, 'id');
            if (! $mediaOrginialGrouped->has($id)) {
                (new MediaProduct())
                    ->fill([
                        'media_id' => $id,
                        'product_id' => $this->id,
                        'media_type' => array_get($media, 'type')
                    ])->save();
            } else {
                if ($mediaOrginialGrouped->get($id)->first()->media_type !== array_get($media, 'type')) {
                    $mediaOrginialGrouped->get($id)->first()->update(['media_type' => array_get($media, 'type')]);
                }
            }
        }
        $toDetach = $mediaOrginial->filter(function ($row) use ($ids) {
            return ! in_array($row->media_id, $ids);
        });
        foreach ($toDetach as $detachable) {
            $detachable->delete();
        }

        return true;
    }
}
