<?php

namespace booyah\WOPP\Models\Traits;

use Exception;

trait SoftDeletes
{
    /**
     * Indicates if the model is currently force deleting.
     *
     * @var bool
     */
    protected $forceDeleting = false;

    /**
     * Force a hard delete on a soft deleted model.
     *
     * This method protects developers from running forceDelete when trait is missing.
     *
     * @return bool|null
     * @throws Exception
     */
    public function forceDelete()
    {
        $this->forceDeleting = true;

        return $this->delete();
    }

    /**
     * Perform the actual delete query on this model instance.
     *
     * @return mixed
     */
    protected function performDeleteOnModel()
    {
        $this->exists = false;

        if ($this->forceDeleting) {
            $this->forceDeleting = false;

            return parent::performDeleteOnModel();
        }

        return $this->wpDB->update($this->getTable(), [$this->getDeletedAtColumn() => date('Y-m-d H:i:s')], [$this->getKeyName() => $this->getKey()]);
    }

    /**
     * Get the name of the "deleted at" column.
     *
     * @return string
     */
    public function getDeletedAtColumn()
    {
        return defined('static::DELETED_AT') ? static::DELETED_AT : 'deleted_at';
    }

    protected function get()
    {
        $this->wheres[] = [
            'column' => $this->getDeletedAtColumn(),
            'operator' => 'IS',
            'value' => 'NULL',
        ];

        return parent::get();
    }
}