<?php

namespace booyah\WOPP\Services;

use booyah\WOPP\Validators\OrderValidatorRules;

class OrderValidationService
{
    protected $validationFields;
    /**
     * @var \Illuminate\Validation\Validator
     */
    protected $validator;
    protected $attributes = [];
    protected $messages = [];
    protected $rules = [];
    private $data;

    public function setFields(array $fields)
    {
        $this->validationFields = $fields;

        return $this;
    }

    public function setAttributes(array $attributes)
    {
        $this->attributes = $attributes;

        return $this;
    }

    public function setMessages(array $messages)
    {
        $this->messages = $messages;

        return $this;
    }

    public function setData(array $data)
    {
        $this->data = $data;

        $this->validationFields = array_merge($this->validationFields, array_keys($data));

        return $this;
    }

    public function validate()
    {
        if (empty($this->validationFields)) {
            throw new \ErrorException('Missing validation fields.');
        }

        if (empty($this->data)) {
            throw new \ErrorException('Missing validation data.');
        }

        $rules = $this->getRules();

        $this->validator = bew_admin_validator($this->data, $rules, $this->messages, $this->attributes);

        $this->extendValidator();
        $this->validator->passes();

        return $this;
    }

    public function fails()
    {
        return $this->validator->fails();
    }

    public function errors()
    {
        return $this->validator->errors();
    }

    public function addRules(array $rules)
    {
        $this->rules = array_merge($this->rules, $rules);

        return $this;
    }

    private function getRules()
    {
        $rules = [];
        $allFields = bew_orders_get_field(null, true);

        foreach ($this->validationFields as $key) {
            $field = array_get($allFields, $key);
            if (array_get($field ?? [], 'is_active', false)) {
                $rules[$key] = data_get($field, 'rules', []);
            }

            /**
             * Check depending fields
             */
            $additional = array_walk($allFields, function ($field, $additonalKey) use ($key, &$rules) {
                if (array_get($field ?? [], 'is_active', false)) {
                    $quote = "/^required\_if\:".$key."\,.*$/";
                    $filteredRules = preg_grep($quote, data_get($field, 'rules', []));
                    if (! empty($filteredRules)) {
                        $rules[$additonalKey] = data_get($field, 'rules', []);
                    }
                }
            });
        }

        $rules = array_merge($this->rules, $rules);

        return $rules;
    }

    private function extendValidator()
    {
        $this->validator->addExtension('change_date', function ($attribute, $value, $parameters, $validator) {
            return (new OrderValidatorRules())->changeDates($attribute, $value, $parameters, $validator);
        });
        $this->validator->addExtension('moving_date', function ($attribute, $value, $parameters, $validator) {
            return (new OrderValidatorRules())->movingDate($attribute, $value, $parameters, $validator);
        });
        $this->validator->addExtension('postcode', function ($attribute, $value, $parameters, $validator) {
            return preg_match("/^[\d]{5}$/", $value) > 0;
        });

        $this->validator->setCustomMessages([
            'change_date' => 'Ungültiges Wechseldatum',
            'moving_date' => 'Ungültiges Umzugsdatum',
            'postcode' => 'Ungültige Postleitzahl',
        ]);
    }
}
