<?php

namespace booyah\WOPP\Services;

use booyah\WOPP\Helpers\Collection;
use booyah\WOPP\Helpers\Fluent;
use booyah\WOPP\Models\Product;

class PriceService
{
    /**
     * @var string
     */
    protected $energyType;

    /**
     * @var bool
     */
    protected $onlyExistingCustomers;

    /**
     * @var int
     */
    protected $usage;

    /**
     * @var int
     */
    protected $usageNt;

    /**
     * @var string
     */
    protected $date;

    /**
     * @var string
     */
    protected $postcode;

    /**
     * @var int
     */
    protected $customerType = 0;

    /**
     * @var bool
     */
    protected $isHtNt = false;

    public function __construct()
    {
        $this->date = date('Y-m-d H:i:s');
    }

    /**
     * @param $energyType
     *
     * @return $this
     */
    public function setEnergyType($energyType): self
    {
        $this->energyType = $energyType;

        return $this;
    }

    /**
     * @param $energyType
     *
     * @return $this
     */
    public function onlyExistingCustomers($onlyExistingCustomers): self
    {
        $this->onlyExistingCustomers = $onlyExistingCustomers;

        return $this;
    }


    /**
     * @param int $usage
     *
     * @return $this
     */
    public function setUsage($usage): self
    {
        $this->usage = $usage;

        return $this;
    }

    /**
     * @param int $usageNt
     *
     * @return $this
     */
    public function setUsageNt($usageNt): self
    {
        $this->usageNt = $usageNt;
        $this->isHtNt = true;

        return $this;
    }

    /**
     *
     * @return $this
     */
    public function setCustomerType($customerType): self
    {
        $this->customerType = $customerType;

        return $this;
    }

    /**
     * @param string $date
     *
     * @return $this
     */
    public function setDate($date): self
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @param $postcode
     *
     * @return $this
     */
    public function setPostcode($postcode): self
    {
        $this->postcode = $postcode;

        return $this;
    }

    /**
     * @return bool
     */
    public function isHtNt()
    {
        return $this->isHtNt;

        return $this;
    }

    /**
     * @return Collection
     */
    public function calculate()
    {
        $result = new Collection();
        $priceCalculationService = new PriceCalculationService();
        $priceCalculationService->setUsage($this->usage)->setPostcode($this->postcode)->setDate($this->date)->setCustomerType($this->customerType);

        if ($this->isHtNt) {
            $priceCalculationService->setUsageNt($this->usageNt);
        }
        $products = Product::where('energy_type', $this->energyType)->whereCustomerType($this->customerType);

        if (! is_null($this->onlyExistingCustomers)) {
            $products = $products->whereOnlyExistingCustomers($this->onlyExistingCustomers);
        }

        $products = $products->get();

        $products->each(function ($product) use (&$result, &$priceCalculationService) {
            $priceCalculationService->setProduct($product);

            $price = $priceCalculationService->calculate();
            if ($price !== null) {
                $result->push(new Fluent([
                    'product' => $product,
                    'price' => $price,
                ]));
            }
        });

        return $result;
    }
}
