<?php

namespace booyah\WOPP\Validators;

use Carbon\Carbon;
use Illuminate\Support\Collection;

class OrderValidatorRules
{
    public function changeDates($attribute, $value, $parameters, $validatorInstance)
    {
        $options = get_option('wopp_order_settings') ?? [];
        $changeSettings = new Collection(array_get($options, 'change.supplier', []));
        $add = (int) $changeSettings->get('add');
        try {
            $date = Carbon::parse($value);
        } catch (\Exception $e) {
            return false;
        }

        if ($changeSettings->get('type') === 'free') {
            if ($add > 0) {
                $compare = Carbon::now()->startOfDay();
                switch ($changeSettings->get('add-type')) {
                    case 'days':
                        $compare->addDays($add);
                        break;
                    case 'weeks':
                        $compare->addWeeks($add);
                        break;
                    case 'months':
                        $compare->addMonths($add);
                        break;
                }

                return $compare->lte($date);
            }

            return true;
        } elseif ($changeSettings->get('type') === 'fix') {
            $dates = \booyah_wopp_get_change_dates();

            return in_array($date->format('Y-m-d'), $dates);
        }
    }

    public function movingDate($attribute, $value, $parameters, $validatorInstance)
    {
        $options = get_option('wopp_order_settings') ?? [];
        $days = array_get($options, 'change.movement.days', 0);
        $date = Carbon::parse($value);
        $compare = Carbon::now()->startOfDay()->subDays($days);

        return $compare->lte($date);
    }
}
