<div class="wrap">
    <h1 class="wp-heading-inline">{{ __('Orders', LANG_DOMAIN) }}</h1>

    <table class="wp-list-table widefat fixed striped products">
        <thead>
        <tr>
            <th>{{ __('Name', LANG_DOMAIN) }}</th>
            <th>{{ __('Created at', LANG_DOMAIN) }}</th>
            <th>{{ __('Exported at', LANG_DOMAIN) }}</th>
            <th>{{ __('Actions', LANG_DOMAIN) }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach ($orders as $order)
                <tr>
                    <td>{{ $order->first_name }} {{ $order->last_name }}</td>
                    <td>{{ format_date($order->created_at, 'd.m.Y H:i:s') }}</td>
                    <td>{{ format_date($order->exported_at, 'd.m.Y H:i:s') ?? __('not exported', LANG_DOMAIN) }}</td>
                    <td><a href="{{ menu_page_url('bew-orders-show', false) }}&id={{ $order->id }}" target="_self">{{ __('Details', LANG_DOMAIN) }}</a></td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
        <tr>
            <th>{{ __('Name', LANG_DOMAIN) }}</th>
            <th>{{ __('Created at', LANG_DOMAIN) }}</th>
            <th>{{ __('Exported at', LANG_DOMAIN) }}</th>
            <th>{{ __('Actions', LANG_DOMAIN) }}</th>
        </tr>
        </tfoot>
    </table>
</div>