<div class="wrap">
    <h1>{{ __('Fieldsettings', LANG_DOMAIN) }}</h1>
    @if ($messages->isNotEmpty())
        <div id="message" class="updated notice is-dismissible">
            <p> <strong>{{ $messages->first() }}</strong></p>
        </div>
    @endif
    <form method="post" class="form-table wopp-admin-order-options--form">
        <table>
            @foreach ($orderFields->groupBy('parent', true) as $fieldKey => $fields)
                <tr>
                    <th><h3>{{ __($fieldKey, LANG_DOMAIN) }}</h3></th>
                </tr>
                <tr>
                    <td>{{ __('Field', LANG_DOMAIN) }}</td>
                    @if (current_user_can('booyah_super_orders'))
                        <td>{{ __('Show for User', LANG_DOMAIN) }}</td>
                    @endif
                    <td>{{ __('Show', LANG_DOMAIN) }}</td>
                    <td>{{ __('Required', LANG_DOMAIN) }}</td>
                    <td>{{ __('Options', LANG_DOMAIN) }}</td>
                </tr>
                @foreach ($fields as $key => $field)
                    <tr>
                        <th>{{ __($key, LANG_DOMAIN) }}</th>
                        @if (current_user_can('booyah_super_orders'))
                            <td>
                                <input type="hidden" name="show[{{ $key }}]" value="0">
                                <input type="checkbox" name="show[{{ $key }}]" value="1" {{ data_get($field, 'show', false) ? 'checked' : '' }}>
                            </td>
                        @endif
                        <td>
                            <input type="hidden" name="active[{{ $key }}]" value="0">
                            <input type="checkbox" name="active[{{ $key }}]" value="1" {{ data_get($field, 'is_active', false) ? 'checked' : '' }}>
                        </td>
                        <td>
                            <input type="hidden" name="required[{{ $key }}]" value="0">
                            <input type="checkbox" name="required[{{ $key }}]" value="1" {{ data_get($field, 'is_required', false) ? 'checked' : '' }}>
                        </td>
                        @if (count(data_get($field, 'options', [])) > 0)
                            <td>
                                @foreach (data_get($field, 'options') as $optionKey => $values)
                                    <label for="{{ $key }}.{{ $optionKey }}">{{ __($key . '.' . $optionKey, LANG_DOMAIN) }}</label>:
                                    <input type="hidden" name="options[{{ $key }}][{{ $optionKey }}]" value="0">
                                    <input type="checkbox" id="{{ $key }}.{{ $optionKey }}" name="options[{{ $key }}][{{ $optionKey }}]" value="1" {{ data_get($values, 'is_active', false) ? 'checked' : '' }}>
                                @endforeach
                            </td>
                        @endif
                    </tr>
                @endforeach
            @endforeach
            <tr class="wopp-admin-order-option--form--submit">
                <th>
                    <button type="submit" class="button button-primary">Speichern</button>
                </th>
            </tr>
        </table>
    </form>
</div>