<div class="wrap">
    <h1 class="wp-heading-inline"><?= __('Orders', LANG_DOMAIN) ?></h1>
    {{--
        Persönliche Daten
    --}}
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Persönliche Daten</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Anrede</b>
            </th>
            <td>
                @if(! empty(trim($order->salutation)))
                    @if($order->salutation == 'male')
                        Herr
                    @elseif($order->salutation == 'female')
                        Frau
                    @elseif($order->salutation == 'other')
                        Sonstiges
                    @else
                        Firma
                    @endif
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
            <th>
                <b>Titel</b>
            </th>
            <td>
                @if(! empty(trim($order->title)))
                    {{ $order->title }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>Vorname</b>
            </th>
            <td>
                @if(! empty(trim($order->first_name)))
                    {{ $order->first_name }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
            <th>
                <b>Nachname</b>
            </th>
            <td>
                @if(! empty(trim($order->last_name)))
                    {{ $order->last_name }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>Geburtstag</b>
            </th>
            <td>
                @if(! empty(trim($order->birthday)))
                    {{ format_date($order->birthday) }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
            <th>
                <b>Telefon-Nr.</b>
            </th>
            <td>
                @if(! empty(trim($order->phone_number)))
                    {{ $order->phone_number }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>E-Mail-Adresse</b>
            </th>
            <td colspan="3">
                @if(! empty(trim($order->email)))
                    {{ $order->email }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
    </table>
    <br><br>
    {{--
        Liefer- und Rechnungsanschrift
    --}}
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Lieferanschrift</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Postleitzahl</b>
            </th>
            <td>
                @if(! empty(trim($order->shipping_postcode)))
                    {{ $order->shipping_postcode }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
            <th>
                <b>Lieferadresse Ort</b>
            </th>
            <td>
                @if(! empty(trim($order->shipping_city)))
                    {{ $order->shipping_city }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>Lieferadresse Straße</b>
            </th>
            <td>
                @if(! empty(trim($order->shipping_street)))
                    {{ $order->shipping_street }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
            <th>
                <b>Lieferadresse Hausnummer</b>
            </th>
            <td>
                @if(! empty(trim($order->shipping_house_number)))
                    {{ $order->shipping_house_number }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
    </table>
    <br><br>
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Rechnungsanschrift</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Abweichend zur Lieferadresse?</b>
            </th>
            <td>
                {{ $order->billing_address_different == '1' ? 'Ja' : 'Nein' }}
            </td>
            <td colspan="2"></td>
        </tr>
        @if($order->billing_address_different == '1')
            <tr>
                <th>
                    <b>Vorname</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_first_name)))
                        {{ $order->billing_first_name }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Nachname</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_last_name)))
                        {{ $order->billing_last_name }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
            <tr>
                <th>
                    <b>Postleitzahl</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_postcode)))
                        {{ $order->billing_postcode }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Ort</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_city)))
                        {{ $order->billing_city }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
            <tr>
                <th>
                    <b>Straße</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_street)))
                        {{ $order->billing_street }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Hausnummer</b>
                </th>
                <td>
                    @if(! empty(trim($order->billing_house_number)))
                        {{ $order->billing_house_number }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
        @endif
    </table>
    <br><br>
    {{--
        Wechseldaten
    --}}
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Wechseldaten</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Wechselart</b>
            </th>
            <td>
                @if($order->order_type == '0')
                    Versorgerwechsel
                @elseif($order->order_type == '1')
                    Umzug
                @elseif($order->order_type == '2')
                    Neueinzug
                @endif
            </td>
            <th>
                <b>Zählernummmer</b>
            </th>
            <td>
                @if(! empty(trim($order->meter_number)))
                    {{ $order->meter_number }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>Zählerstand</b>
            </th>
            <td colspan="3">
                @if(! empty(trim($order->meter_reading)))
                    {{ $order->meter_reading }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        @if($order->order_type == 0)
            <tr>
                <th>
                    <b>Vorversorger Code</b>
                </th>
                <td>
                    @if(! empty(trim($order->previous_supplier_code)))
                        {{ $order->previous_supplier_code }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Vorversorger Name</b>
                </th>
                <td>
                    @if(! empty(trim($order->previous_supplier_name)))
                        {{ $order->previous_supplier_name }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
            <tr>
                <th>
                    <b>Vorversorger Kundennummer</b>
                </th>
                <td>
                    @if(! empty(trim($order->previous_supplier_customer_number)))
                        {{ $order->previous_supplier_customer_number }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Wunschtermin</b>
                </th>
                <td>
                    @if(! empty(trim($order->desired_at)))
                        {{ format_date($order->desired_at) }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
            <tr>
                <th>
                    <b>Bereits gekündigt</b>
                </th>
                <td>
                    @if(is_numeric(trim($order->is_cancelled)))
                        {{ $order->is_cancelled == '1' ? 'Ja' : 'Nein' }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                @if($order->is_cancelled == '1')
                    <th>
                        Gekündigt zum
                    </th>
                    <td>
                        @if(! empty(trim($order->cancelled_at)))
                            {{ format_date($order->cancelled_at) }}
                        @else
                            <i class="fas fa-minus fa-fw"></i>
                        @endif
                    </td>
                @else
                    <td colspan="2"></td>
                @endif
            </tr>
        @else
            <tr>
                <th>
                    <b>Einzugsdatum</b>
                </th>
                <td>
                    @if(! empty(trim($order->moving_in_at)))
                        {{ format_date($order->moving_in_at) }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>Ablesedatum</b>
                </th>
                <td>
                    @if(! empty(trim($order->reading_at)))
                        {{ format_date($order->reading_at) }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
        @endif
    </table>
    <br><br>
    {{--
        Zahlungsinformationen
    --}}
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Zahlungsinformationen</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Zahlungsart</b>
            </th>
            <td>
                @if($order->payment_method == '0')
                    SEPA-Basislastschrift
                @elseif($order->payment_method == '1')
                    Überweisung
                @elseif($order->payment_method == '2')
                    PayPal
                @endif
            </td>
            @if($order->payment_method == 0)
                <th>
                    <b>Konto Inhaber</b>
                </th>
                <td>
                    @if(! empty(trim($order->account_owner)))
                        {{ $order->account_owner }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            @endif
            @if($order->payment_method == 2)
                <th>
                    <b>PayPal E-Mail-Adresse</b>
                </th>
                <td>
                    @if(! empty(trim($order->paypal_email)))
                        {{ $order->paypal_email }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            @endif
        </tr>
        @if($order->payment_method == 0)
            <tr>
                <th>
                    <b>IBAN</b>
                </th>
                <td>
                    @if(! empty(trim($order->iban)))
                        {{ $order->iban }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
                <th>
                    <b>BIC</b>
                </th>
                <td>
                    @if(! empty(trim($order->bic)))
                        {{ $order->bic }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
            <tr>
                <th>
                    <b>Bankname</b>
                </th>
                <td colspan="3">
                    @if(! empty(trim($order->bankname)))
                        {{ $order->bankname }}
                    @else
                        <i class="fas fa-minus fa-fw"></i>
                    @endif
                </td>
            </tr>
        @endif
    </table>
    <br><br>
    {{--
        Tarifinformationen
    --}}
    <table class="wp-list-table widefat fixed striped products">
        <tr>
            <th colspan="4">
                <h3>Tarifinformationen</h3>
            </th>
        </tr>
        <tr>
            <th>
                <b>Sparte</b>
            </th>
            <td>
                <?= format_energy_type($product->energy_type) ?>
            </td>
            <th>
                <b>Netzwerknummer</b>
            </th>
            <td>
                @if(! empty(trim($order->networknumber)))
                    {{ $order->networknumber }}
                @else
                    <i class="fas fa-minus fa-fw"></i>
                @endif
            </td>
        </tr>
        <tr>
            <th>
                <b>Produkt</b>
            </th>
            <td>
                <?= $product->name ?>
            </td>
            <th>
                <b>Tariftyp</b>
            </th>
            <td>
                {{ $order->usage_price_et > 0 ? 'Eintarif' : 'Doppeltarif' }}
            </td>
        </tr>
        @if($order->usage_price_et > 0)
            <tr>
                <th>
                    <b>Verbrauch</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage, 0) }} kWh
                </td>
                <th>
                    <b>Arbeitspreis</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage_price_et * 100) }} ct/kWh
                </td>
            </tr>
        @else
            <tr>
                <th>
                    <b>Verbrauch HT</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage, 0) }} kWh
                </td>
                <th>
                    <b>Arbeitspreis HT</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage_price_ht * 100) }} ct/kWh
                </td>
            </tr>
            <tr>
                <th>
                    <b>Verbrauch NT</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage_nt, 0) }} kWh
                </td>
                <th>
                    <b>Arbeitspreis NT</b>
                </th>
                <td>
                    {{ number_format_EU($order->usage_price_nt * 100) }} ct/kWh
                </td>
            </tr>
        @endif
        <tr>
            <th>
                <b>Grundpreis</b>
            </th>
            <td>
                {{ number_format_EU($order->base_price) }} €/Monat
            </td>
            <th>
                <b>Mtl. Abschlag</b>
            </th>
            <td>
                @if($order->usage_price_et > 0)
                    {{ number_format_EU((($order->usage_price_et * (int) $order->usage) + ($order->base_price * 12)) / 12) }}
                @else
                    {{ number_format_EU((($order->usage_price_ht * $order->usage) + ($order->usage_price_nt * $order->usage_nt) + ($order->base_price * 12)) / 12) }}
                @endif
                €
            </td>
        </tr>
    </table>
</div>
