<div class="wrap">
    <h1>{{ __('Create new product', LANG_DOMAIN) }}</h1>
    @if ($messages->isNotEmpty())
        <div id="message" class="updated notice is-dismissible">
            <p><strong>{{ $messages->first() }}</strong></p>
        </div>
    @endif
    @if ($errors->count() > 0)
        <div id="message" class="error notice is-dismissible">
            <p><strong>{{ __('Error while saving', LANG_DOMAIN) }}.</strong></p>
        </div>
    @endif
    <form method="post" class="form-table wopp-admin-product--form">
        <table width="75%">
            <tr>
                <th>
                    <label class="row" for="name">{{ __('Name', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input class="row" type="text" id="name" name="name" value="{{ data_get($old, 'name') }}" style="width: 100%; {{ $errors->has('name') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="external_key">{{ __('External key', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="text" id="external_key" name="external_key" value="{{ data_get($old, 'external_key') }}" style="width: 100%; {{ $errors->has('external_key') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="customer_type">Kundentyp</label>
                </th>
                <td>
                    <select id="customer_type" name="customer_type" style="width: 100%; <?= ($errors->has('customer_type') ? 'border: 1px solid red;' : ''); ?>">
                        <option value="0" {{ data_get($old, 'customer_type') == 0 ? 'selected' : '' }}>Privatkunden</option>
                        <option value="1" {{ data_get($old, 'customer_type') == 1 ? 'selected' : '' }}>Gewerbekunden</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="energy_type">{{ __('Energytype', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <select id="energy_type" name="energy_type" style="width: 100%; <?= ($errors->has('energy_type') ? 'border: 1px solid red;' : ''); ?>">
                        <option value="power" {{ data_get($old, 'energy_type') == 'power' ? 'selected' : '' }}>{{ __('Power', LANG_DOMAIN) }}</option>
                        <option value="gas" {{ data_get($old, 'energy_type') == 'gas' ? 'selected' : '' }}>{{ __('Gas', LANG_DOMAIN) }}</option>
                        <option value="heat" {{ data_get($old, 'energy_type') == 'heat' ? 'selected' : '' }}>{{ __('Distance heating', LANG_DOMAIN) }}</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="description">{{ __('Description', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    @php
                        wp_editor(data_get($old, 'description'), 'description', [
                            'media_buttons' => false,
                            'textarea_name' => 'description',
                            'teeny' => true,
                            'quicktags' => [
                                'buttons' => 'strong,em,ul,ol,li,close,spell'
                            ],
                            'tinymce' => [
                                'menubar' => 'edit view format table',
                                'toolbar' => 'bold, italic, underline, strikethrough, alignleft, aligncenter, alignright, alignjustify, styleselect, formatselect, fontselect, fontsizeselect, cut, copy, paste, bullist, numlist, outdent, indent, blockquote, undo, redo, removeformat, subscript, superscript',
                                'fontsize_formats' => '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
                                'plugins' => 'table wordcount code',
                            ]
                        ]);
                    @endphp
                </td>
            </tr>
            <tr>
                <th>
                    <label for="slogan_priceshow">Slogan Preisanzeige</label>
                </th>
                <td>
                    <input type="text" id="slogan_priceshow" name="slogan_priceshow" value="{{ data_get($old, 'slogan_priceshow') }}" style="width: 100%; {{ $errors->has('slogal_priceshow') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="slogan_contract">Slogan Bestellprozess</label>
                </th>
                <td>
                    <input type="text" id="slogan_contract" name="slogan_contract" value="{{ data_get($old, 'slogan_contract') }}" style="width: 100%; {{ $errors->has('slogan_contract') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="additional_info">Zusatz Information<br><small>Sichtbar in Preisanzeige und Bestellprozess</small></label>
                </th>
                <td>
                    <input type="text" id="additional_info" name="additional_info" value="{{ data_get($old, 'additional_info') }}" style="width: 100%; {{ $errors->has('additional_info') ? 'border: 1px solid red;' : '' }}">
                </td>
            </tr>
            <tr>
                <th>{{__('Contract period', LANG_DOMAIN)}}</th>
                <td>
                    <input type="number" min="1" step="1" id="contract_period" name="contract_period" value="{{ data_get($old, 'contract_period', 1) }}" style="width: 25%; {{ $errors->has('contract_period') ? 'border: 1px solid red;' : '' }}">
                    <select class="" name="contract_period_type">
                        <option value="months" <?= array_get($old, 'contract_period_type') === 'months' ? 'selected=""' : '' ?>>{{ __('months', LANG_DOMAIN) }}</option>
                        <option value="years" <?= array_get($old, 'contract_period_type') === 'weeks' ? 'selected=""' : '' ?>>{{__('years', LANG_DOMAIN)}}</option>                        
                    </select>
                </td>
            </tr>
            <tr>
                <th>{{__('Price warranty', LANG_DOMAIN)}}</th>
                <td>
                    <div>
                        <input type="number" min="0" step="1" id="price_warranty" name="price_warranty" value="{{ data_get($old, 'price_warranty', 0) }}" style="width: 25%; {{ $errors->has('price_warranty') ? 'border: 1px solid red;' : '' }}">
                        <select class="" name="price_warranty_type">
                            <option value="months" <?= array_get($old, 'price_warranty_type') === 'months' ? 'selected=""' : '' ?>>{{ __('months', LANG_DOMAIN) }}</option>
                            <option value="years" <?= array_get($old, 'price_warranty_type') === 'weeks' ? 'selected=""' : '' ?>>{{__('years', LANG_DOMAIN)}}</option>

                        </select>
                    </div>
                    <br>
                    <div>
                        <input type="text" id="price_warranty_fixed" name="price_warranty_fixed" value="{{ data_get($old, 'price_warranty_fixed') }}" style="width: 100%; {{ $errors->has('price_warranty_fixed') ? 'border: 1px solid red;' : '' }}"><br>
                    </div>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="is_active">{{ __('Active', LANG_DOMAIN) }}</label>
                </th>
                <td>
                    <input type="hidden" name="is_active" value="0">
                    <input type="checkbox" id="is_active" name="is_active" value="1" style="{{ $errors->has('is_active') ? 'border: 1px solid red;' : '' }}" {{ data_get($old, 'is_active') == '1' ? 'checked' : '' }}>
                </td>
                <th>
                    <label for="is_active">Von Empfehlung ausschließen</label>
                </th>
                <td>
                    <input type="hidden" name="exclude_from_recommendations" value="0">
                    <input type="checkbox" id="exclude_from_recommendations" name="exclude_from_recommendations" value="1" style="{{ $errors->has('exclude_from_recommendations') ? 'border: 1px solid red;' : '' }}" {{ data_get($old, 'exclude_from_recommendations') == '1' ? 'checked' : '' }}>
                </td>
            </tr>
            <tr>
                <th>
                    <label for="is_active">Nur für Bestandskunden (Kombiprodukt)</label>
                </th>
                <td>
                    <input type="hidden" name="only_existing_customers" value="0">
                    <input type="checkbox" id="only_existing_customers" name="only_existing_customers" value="1" style="{{ $errors->has('only_existing_customers') ? 'border: 1px solid red;' : '' }}" {{ data_get($old, 'only_existing_customers') == '1' ? 'checked' : '' }}>
                </td>
            </tr>
            <tr class="file_row">
                <th>
                    <label>{{ __('Icon') }}</label>
                </th>
                <td>
                    <div style="width:10%; float:right;">
                        <a href="javascript:;" class="image-select" data-media-target="product-icon">{{ __('Choose', LANG_DOMAIN) }}</a>
                    </div>
                    <div style="width:90%">
                        @php($iconTitle = '')
                        @if (array_get($old, 'icon_id'))
                            @php($iconTitle = WP_Post::get_instance(array_get($old, 'icon_id'))->post_title)
                        @endif
                        <input type="text" value="{{ $iconTitle }}" readonly="" data-media="product-icon" data-media-attr="title"  style="width:100%; {{ $errors->has('icon_id') ? 'border: 1px solid red;' : '' }}">
                        <input type="hidden" name="icon_id" value="{{ array_get($old, 'icon_id') }}" data-media="product-icon" data-media-attr="id">
                    </div>
                </td>
            </tr>
            <tr class="input-group ">
                <th>
                    <label for="file">{{ __('Files', LANG_DOMAIN) }}</label>
                    <a href="javascript:;" id="add-file">{{ __('Add ', LANG_DOMAIN) }}</a>
                </th>
            </tr>
            @if (array_has($old, 'file'))
                @foreach (array_get($old, 'file') as $index => $value)
                    @php($post = WP_Post::get_instance($value))
                    <tr class="file_row">
                        <td>
                            <a href="javascript:;" class="media-select" data-media-target="product-files">{{ __('Choose', LANG_DOMAIN) }}</a>&nbsp;|&nbsp;<a href="javascript:;" class="remove-file-link">{{ __('Remove', LANG_DOMAIN) }}</a>
                        </td>
                        <td>
                            <input type="text" class="media-select" value="{{ $post->post_title }}" readonly="" data-media-target="product-files" data-media="product-files" data-media-attr="title"  style="width:100%; {{ $errors->has('file.'.$index) ? 'border: 1px solid red;' : '' }}">
                            <input type="hidden" name="file[]" value="{{ $value }}" data-media="product-files" data-media-attr="id">
                        </td>
                        <td>
                            <select name="file_type[]" style="{{ $errors->has('file_type.'.$index) ? 'border: 1px solid red;' : '' }}">
                                <option value="tos" {{ data_get($old, 'file_type.'.$index) == 'tos' ? 'selected' : '' }}>{{ __('TOS', LANG_DOMAIN) }}</option>
                                <option value="pricefile" {{ data_get($old, 'file_type.'.$index) == 'pricefile' ? 'selected' : '' }}>{{ __('Pricefile', LANG_DOMAIN) }}</option>
                                <option value="other" {{ data_get($old, 'file_type.'.$index) == 'other' ? 'selected' : '' }}>{{ __('Other', LANG_DOMAIN) }}</option>
                            </select>
                        </td>
                    </tr>
                @endforeach
            @endif
            <tr class="wopp-admin-product--form--submit">
                <th>
                    <button type="submit" class="button button-primary">{{ __('Create product', LANG_DOMAIN) }}</button>
                </th>
            </tr>
        </table>
    </form>
    <table id="template" style="display:none;">
        <tr class="file_row" style="display:none;">
            <td>
                <a href="javascript:;" class="media-select" data-media-target="product-files">{{ __('Choose', LANG_DOMAIN) }}</a>&nbsp;|&nbsp;<a href="javascript:;" class="remove-file-link">{{ __('Remove', LANG_DOMAIN) }}</a>
            </td>
            <td>
                <input type="text" class="media-select" value="" readonly="" data-media-target="product-files" data-media="product-files" data-media-attr="title" style="width:100%;">
                <input type="hidden" name="file[]" value="" data-media="product-files" data-media-attr="id">
            </td>
            <td>
                <select name="file_type[]">
                    <option value="tos" {{ data_get($old, 'file_type') == 'tos' ? 'selected' : '' }}>{{ __('TOS', LANG_DOMAIN) }}</option>
                    <option value="pricefile" {{ data_get($old, 'file_type') == 'pricefile' ? 'selected' : '' }}>{{ __('Pricefile', LANG_DOMAIN) }}</option>
                    <option value="other" {{ data_get($old, 'file_type') == 'other' ? 'selected' : '' }}>{{ __('Other', LANG_DOMAIN) }}</option>
                </select>
            </td>
        </tr>
    </table>
</div>
