# Legacystead

## Initiale Einrichtung

### Entfernt die Umgebungsvariable und das Repository/Ordner für legacystead in Windows
Falls ihr legacystead noch nie benutzt habt ist das nicht erforderlich.

### Host Datei anpassen
192.168.0.52 packages.redtree.de

### Globale config.json von composer anpassen

Die Datei liegt in **C:\Users\BENUTZERNAME\AppData\Roaming\Composer\config.json**
Folgendes muss hinzugefügt werden:

```
{
    "repositories": [
        {
            "type": "composer",
            "url": "http://packages.redtree.de"
        }
    ]
}
```


### Installation von legacystead

#### Box installieren

```
vagrant box add moessimple/legacystead
```

#### Legacystead package installieren
```
composer global require "maurice/legacystead"
```

#### Überprüfen ob alles korrekt ist

Öffnet die git bash und gebt folgendes ein:

```
which legacystead
```

Als Ergebnis muss so etwas raus kommen

**/c/Users/BENUTZERNAME/AppData/Roaming/Composer/vendor/bin/legacystead**

heißt er nimmt jetzt das composer package

Ist dies nicht der Fall müsst ihr das bin Verzeichnis zur Umgebungsvariable PATH hinzufügen und zwar so

Sucht bei Windows nach **Umgebungsvariablen für diese Konto bearbeiten** und erweitert die **PATH** Variable. Ungefähr so
**C:\Users\BENUTZERNAME\AppData\Roaming\Composer\vendor\bin**

#### Initialisierung von notwenigen Dateien

```
legacystead init
```

Bei den Leuten die schon legacystead zu vor hatten wird soetwas kommen
**Legacystead has already been initialized.** Keine Panik ihr müsst nichts machen.

#### Anpassung der Konfiguration

```
legacystead edit
```

Öffnet die Legacystead.yaml, passt entsprechend die Konfiguration an


#### after.sh anpassen

Liegt in **C:\Users\BENUTZERNAME\.legacystead**

Fügt folgenden Inhalt hinzu

```
#### Add host entries
cat > /etc/hosts << EOF

127.0.0.1 localhost

# The following lines are desirable for IPv6 capable hosts
::1 ip6-localhost ip6-loopback
fe00::0 ip6-localnet
ff00::0 ip6-mcastprefix
ff02::1 ip6-allnodes
ff02::2 ip6-allrouters
ff02::3 ip6-allhosts
127.0.1.1 legacystead legacystead

192.168.0.10    www.loop-cloud.de loop-cloud.de loop-cloud
192.168.0.20    analytics.loop-cloud.de
192.168.0.30    enet.loop-cloud.de
192.168.0.40    shared.loop-cloud.de loop-shared-server
192.168.0.40    www.masterloop.de
192.168.0.70    monitoring.loop-cloud.de
192.168.0.22    portal.redtree-cloud.de
192.168.0.107   syslog.redtree-cloud.de

192.168.0.10    loop-src.loop-cloud.de
192.168.0.10    loop-lib.loop-cloud.de
EOF
```

#### Maschine hochfahren

```
legacystead up
```

#### Änderung and Legacystead.yaml oder after.sh aktualisieren

Falls ihr irgendwas an der Legacystead.yaml oder after.sh ändern müsst ihr die Kiste erneut provisionieren.
Heißt nichts anderes er nimmt diese beiden Dateien und ändert entsprechend die Box. Legt domains an, Datenbank, Scripte in after.sh etc.
Dafür muss die Kiste aber bereits gestartet sein.

```
legacystead provision
```


### Updates

Jedesmal wenn ihr die Kiste startet sucht vagrant automatisch nach einer neuen Box und gibt Euch ein Hinweis, falls es eine neue gibt.
Diesen Befehl müsst ihr dann nur ausführen. Der da heißt:

```
vagrant box update
```

Falls dieser Befehl nicht adhoc funktioniert wechselt in das Composer Verzeichnis. Dort wo das **Vagrantfile** liegt **/c/Users/BENUTZERNAME/AppData/Roaming/Composer/vendor/maurice/legacystead**

Falls ich irgendetwas an legacystead ändere reicht ein

```
composer global update
```

### Projekte

#### Datenbanken
##### Außerhalb Redtree's

Außerhalb des Redtree Lans ohne VPN-Verbindung, kann die lokale Datenbank genutzt werden. Die Zugangsdaten für die lokale Datenbank sind **User:legacystead** **Passwort: secret**.

Um die Datenbank einspielen zu können, braucht man maximal 2 Dateien. Die Struktur der Datenbank und die Daten. Beides kann via *PHPMyAdmin* exportiert werden.
Zu exkludieren sind fogende Tabellen bei den Daten:
* customer_correspondence_file
* loop_repository_item
* price_file


Mit dem Tool *MySqlWorkbench* könnt ihr euch mit
```
host: localhost
port: 33061
```
verbinden. Dort legt ihr dann ein neues Schema an wie die DB heißen soll.
Die beiden auß *PHPMyAdmin* exportierten Dateien können mithilfe der *MySqlWorkbench* eingespielt werden.

Spielt ihr die Dateien von Hand ein, müssen sie auf der Legeacystead Maschine verfügbar sein. Das heißt ihr solltet sie in
einen Ordner laden, welcher von legacystead gemountet wird. Danach geht ihr wie folgt vor:
```
# legacystead ssh;
# cd Code/[euerPfad]
# mysql -u legacystead -p [datenbankName] < [euerDateiname].sql
```
Der Datenbank Name ist optional, wenn im SQL-Script ein **Create Database** bzw ein **use** vorhanden ist.

##### Innerhalb des Redtree Netzes

Innerhalb des Redtree Netzes kann der Loop Frontendserver genutzt werden. Dieser ist über die IP:
```
192.168.0.52
```
erreichbar. Dort ist auch ein *PHPMyAdmin* vorhanden. Die Zugangsdaten sind:
```
user:root
password: dinr43
```

#### Projekte

Alle Loop Projekte müssen, damit sie in der legacystead funktionieren angepasst werden.
Zu prüfen sind folgende Dateien auf notwendige Anpassugen:
* .htacess
* index.php
* database.ini
* mailer.ini

Solltet ihr danach trotzdem noch Probleme bei den Projekte haben, müssen die Projekte seperat geprüft werden,
ob sie irgendwo noch eine Hartkodierte URL haben oder angepasst werden müssen (exkludieren der PHP_IDS).

Diese Änderungen müssen vor dem Merge-Request wieder rückgängig gemacht werden, da sie nicht im Live-System auftauchen dürfen.
Wie dieses am besten gemacht wird kann man nicht sage. Es gibt da keinen perfekten Workflow für.

*Bei EH3 gibt es einen Branch um das Testsystem zu nutzen. Wer dieses vorgehen nutzen möchte kann bei Stefan J. nachfragen wie es am besten zu machen ist.*

Für alle Loop Projekte sind die Log-Dateien in **/var/log/apache2**.
Auslesen könnt ihr sie wie folgt:
```
# legacystead ssh;
# sudo su;
# cd /var/log/apache2;
# cat [filename]
```
