#!/usr/bin/env bash

mkdir -p /etc/apache2/ssl 2>/dev/null
openssl genrsa -out "/etc/apache2/ssl/$1.key" 1024 2>/dev/null
openssl req -new -key /etc/apache2/ssl/$1.key -out /etc/apache2/ssl/$1.csr -subj "/CN=$1/O=Vagrant/C=UK" 2>/dev/null
openssl x509 -req -days 365 -in /etc/apache2/ssl/$1.csr -signkey /etc/apache2/ssl/$1.key -out /etc/apache2/ssl/$1.crt 2>/dev/null

block="<VirtualHost *:80>
        ServerName $1
        DocumentRoot $2
        <Directory $2>
            Options -Indexes FollowSymLinks MultiViews
            AllowOverride All
            Order allow,deny
            allow from all
        </Directory>
        ErrorLog /var/log/apache2/$1-error.log
        LogLevel warn
        CustomLog /var/log/apache2/$1-custom.log combined
    </VirtualHost>

    <VirtualHost *:443>
        SSLEngine on
        SSLCertificateFile /etc/apache2/ssl/$1.crt
        SSLCertificateKeyFile /etc/apache2/ssl/$1.key

        ServerName $1
        DocumentRoot $2
        <Directory $2>
            Options -Indexes FollowSymLinks MultiViews
            AllowOverride All
            Order allow,deny
            allow from all
        </Directory>
        ErrorLog /var/log/apache2/$1-ssl-error.log
        LogLevel warn
        CustomLog /var/log/apache2/$1-ssl-custom.log combined
    </VirtualHost>

"

echo "$block" > "/etc/apache2/sites-available/$1"
ln -fs "/etc/apache2/sites-available/$1" "/etc/apache2/sites-enabled/$1"
service apache2 restart
