<?php namespace Redtree\Legacystead;

use Symfony\Component\Process\Process;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class InitCommand extends Command {

	/**
	 * Configure the command options.
	 *
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('init')
                  ->setDescription('Create a stub Legacystead.yaml file');
	}

	/**
	 * Execute the command.
	 *
	 * @param  \Symfony\Component\Console\Input\InputInterface  $input
	 * @param  \Symfony\Component\Console\Output\OutputInterface  $output
	 * @return void
	 */
	public function execute(InputInterface $input, OutputInterface $output)
	{
		if (is_dir(legacystead_path()))
		{
			throw new \InvalidArgumentException("Legacystead has already been initialized.");
		}

		mkdir(legacystead_path());

		copy(__DIR__.'/stubs/Legacystead.yaml', legacystead_path().'/Legacystead.yaml');
		copy(__DIR__.'/stubs/after.sh', legacystead_path().'/after.sh');
		copy(__DIR__.'/stubs/aliases', legacystead_path().'/aliases');

		$output->writeln('<comment>Creating Legacystead.yaml file...</comment> <info>✔</info>');
		$output->writeln('<comment>Legacystead.yaml file created at:</comment> '.legacystead_path().'/Legacystead.yaml');
	}

}
