<?php namespace Redtree\Legacystead;

use Symfony\Component\Process\Process;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SshCommand extends Command {

	/**
	 * Configure the command options.
	 *
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('ssh')
                  ->setDescription('Login to the Legacystead machine via SSH');
	}

	/**
	 * Execute the command.
	 *
	 * @param  \Symfony\Component\Console\Input\InputInterface  $input
	 * @param  \Symfony\Component\Console\Output\OutputInterface  $output
	 * @return void
	 */
	public function execute(InputInterface $input, OutputInterface $output)
	{
		chdir(__DIR__.'/../');

		passthru($this->setEnvironmentCommand() . ' vagrant ssh');
	}

	protected function setEnvironmentCommand()
	{
		if ($this->isWindows()) {
			return 'SET VAGRANT_DOTFILE_PATH='.$_ENV['VAGRANT_DOTFILE_PATH'].' &&';
		}

		return 'VAGRANT_DOTFILE_PATH="'.$_ENV['VAGRANT_DOTFILE_PATH'].'"';
	}

	protected function isWindows()
	{
		return strpos(strtoupper(PHP_OS), 'WIN') === 0;
	}

}
