if (typeof Object.assign != 'function') {
    Object.assign = function (target) {
        'use strict';
        if (target == null) {
            throw new TypeError('Cannot convert undefined or null to object');
        }

        target = Object(target);
        for (var index = 1; index < arguments.length; index ++) {
            var source = arguments[index];
            if (source != null) {
                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }
        }
        return target;
    };
}

String.prototype.endsWith = function (suffix) {
    return this.indexOf(suffix, this.length - suffix.length) !== - 1;
};

// -----------------------------------------------------------------------------
// CSS Hooks

$.cssHooks.hexColor = {
    get: function (elem) {
        if (elem.currentStyle) {
            var color = elem.currentStyle["color"];
        } else if (window.getComputedStyle) {
            var color = document.defaultView.getComputedStyle(elem, null).getPropertyValue("color");
        }
        if (color.search("rgb") == - 1)
            return color;
        else {
            color = color.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);

            function hex(x) {
                return ("0" + parseInt(x).toString(16)).slice(- 2);
            }

            return "#" + hex(color[1]) + hex(color[2]) + hex(color[3]);
        }
    }
};
