<?php

namespace Redtree\BooyahWebTemplate;

use Illuminate\Support\ServiceProvider;
use Redtree\BooyahWebTemplate\Services\Views\BreadcrumbService;
use Redtree\BooyahWebTemplate\Services\Views\ThemeService;

class BooyahWebTemplateServiceProvider extends ServiceProvider
{
    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'booyahwebtemplate');
        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'booyahwebtemplate');
        // $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
        // $this->loadRoutesFrom(__DIR__.'/routes.php');

        // Publishing is only necessary when using the CLI.
        if ($this->app->runningInConsole()) {

            // Publishing the configuration file.
            $this->publishes([
                __DIR__ . '/../config/booyahwebtemplate.php' => config_path('booyahwebtemplate.php'),
            ], 'booyahwebtemplate.config');

            // Publishing assets.
            /*$this->publishes([
                __DIR__.'/../resources/assets' => public_path('vendor/redtree'),
            ], 'booyahwebtemplate.views');*/

            // Publishing the translation files.
            /*
            $this->publishes([
                __DIR__.'/../resources/lang' => resource_path('lang/vendor/booyahwebtemplate'),
            ], 'booyahwebtemplate.views');
            */
            // Registering package commands.
            // $this->commands([]);
        }
    }

    /**
     * Register any package services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/booyahwebtemplate.php', 'booyahwebtemplate');

        // Register the service the package provides.
        $this->app->singleton('booyahwebtemplate', function ($app) {
            return new BooyahWebTemplate;
        });
        $this->app->bind('booyahBreadcrumbService', function ($app) {
            return new BreadcrumbService;
        });
        $this->app->singleton('booyahThemeService', function ($app) {
            return new ThemeService;
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['booyahwebtemplate'];
    }
}