var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

if (typeof Object.assign != 'function') {
    Object.assign = function (target) {
        'use strict';

        if (target == null) {
            throw new TypeError('Cannot convert undefined or null to object');
        }

        target = Object(target);
        for (var index = 1; index < arguments.length; index++) {
            var source = arguments[index];
            if (source != null) {
                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }
        }
        return target;
    };
}

String.prototype.endsWith = function (suffix) {
    return this.indexOf(suffix, this.length - suffix.length) !== -1;
};

// -----------------------------------------------------------------------------
// CSS Hooks

$.cssHooks.hexColor = {
    get: function get(elem) {
        if (elem.currentStyle) {
            var color = elem.currentStyle["color"];
        } else if (window.getComputedStyle) {
            var color = document.defaultView.getComputedStyle(elem, null).getPropertyValue("color");
        }
        if (color.search("rgb") == -1) return color;else {
            var hex = function hex(x) {
                return ("0" + parseInt(x).toString(16)).slice(-2);
            };

            color = color.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);

            return "#" + hex(color[1]) + hex(color[2]) + hex(color[3]);
        }
    }
};

var Booyah = function () {
    function Booyah() {
        _classCallCheck(this, Booyah);

        this._abbrevations = {};
        this._routes = {};
        this._customValues = {};
        this.$ = {};

        // AJAX SETUP
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        this.init();
    }

    _createClass(Booyah, [{
        key: 'init',
        value: function init() {
            /************************************************************
             * THEMES
             */

            // Colors
            this.themeColors = {
                primary: null,
                secondary: null,
                success: null,
                info: null,
                warning: null,
                danger: null,
                light: null,
                dark: null
            };

            this.themeChartColorKeys = ['primary', 'secondary', 'info', 'warning', 'danger', 'dark'];

            this.initThemeColors();
        }
    }, {
        key: 'filterObject',
        value: function filterObject(obj, toCheck) {
            var result = {};
            var keys = Object.keys(obj);
            for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                if (toCheck instanceof Function) {
                    if (toCheck(obj[key])) {
                        result[key] = obj[key];
                    }
                } else {
                    if (obj.hasOwnProperty(toCheck)) {
                        if (Boolean(obj[toCheck])) {
                            result[key] = obj[key];
                        }
                    }
                }
            }
            return result;
        }
    }, {
        key: 'addCustomValue',
        value: function addCustomValue(key, value) {
            var override = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

            if (typeof key !== "undefined" && typeof value !== "undefined") {
                if (typeof this._customValues[key] !== 'undefined') {
                    if (override) {
                        this._customValues[key] = value;
                    } else {
                        console.warn('Tried to override custom value \'' + key + '\'');
                    }
                } else {
                    this._customValues[key] = value;
                }
            }
        }
    }, {
        key: 'getCustomValue',
        value: function getCustomValue(key) {
            var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

            if (typeof this._customValues[key] !== 'undefined') {
                return this._customValues[key];
            }

            return fallback;
        }
    }, {
        key: 'initThemeColors',


        /**************************************
         * THEMES & COLORS
         */
        value: function initThemeColors() {
            var themeColorSpan = $('<span class="hidden theme-clr"></span>');
            $('body').append(themeColorSpan);
            var colorKeys = Object.keys(this.themeColors);
            for (var i = 0; i < colorKeys.length; i++) {
                var key = colorKeys[i];
                themeColorSpan.addClass('theme-clr__' + key);
                this.themeColors[key] = themeColorSpan.css('color');
                themeColorSpan.removeClass('theme-clr__' + key);
            }
            themeColorSpan.remove();
        }
    }, {
        key: 'addThemeColors',
        value: function addThemeColors() {
            var colors = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var override = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            var colorKeys = Object.keys(colors);
            for (var i = 0; i < colorKeys.length; i++) {
                if (typeof this.themeColors[colorKeys[i]] !== 'undefined') {
                    if (override) {
                        this.themeColors[colorKeys[i]] = colors[colorKeys[i]];
                    } else {
                        console.warn('Tried to override themecolor \'' + colorKeys[i] + '\' => \'' + colors[colorKeys[i]] + '\'');
                    }
                } else {
                    this.themeColors[colorKeys[i]] = colors[colorKeys[i]];
                }
            }
        }
    }, {
        key: 'getThemeColor',
        value: function getThemeColor(key) {
            if (typeof key === 'number') {
                if (typeof this.themeColors[this.getThemeColorKeys()[key]] !== 'undefined') {
                    return this.themeColors[this.getThemeColorKeys()[key]];
                }
            } else if (typeof key !== 'undefined') {
                if (key in this.themeColors) {
                    return this.themeColors[key];
                }
                return this.themeColors['primary'];
            }

            return this.themeColors;
        }
    }, {
        key: 'addAbbrevations',


        /*************************************+
         * Abbrevations
         */

        value: function addAbbrevations(toAdd) {
            this._abbrevations = Object.assign(this._abbrevations, toAdd);
        }
    }, {
        key: 'getAbbrevationTitle',
        value: function getAbbrevationTitle(key) {
            return Booyah.objectGet(key, this.getAbbrevations, '');
        }
    }, {
        key: 'getAbbrHtml',
        value: function getAbbrHtml(abbreviation) {
            var title = this.getAbbrevationTitle(abbreviation);
            if (title.trim() !== '') {
                return '<abbr title="' + title + '">' + abbreviation + '</abbr>';
            }

            return abbreviation;
        }
    }, {
        key: 'addRoutes',
        value: function addRoutes() {
            var routes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var override = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            var routeKeys = Object.keys(routes);
            for (var i = 0; i < routeKeys.length; i++) {
                if (typeof this.getRoutes[routeKeys[i]] !== 'undefined') {
                    if (override) {
                        this._routes[routeKeys[i]] = routes[routeKeys[i]];
                    } else {
                        console.warn('Tried to override route \'' + routeKeys[i] + '\' => \'' + routes[routeKeys[i]] + '\'');
                    }
                } else {
                    this._routes[routeKeys[i]] = routes[routeKeys[i]];
                }
            }
        }
    }, {
        key: 'addRoute',
        value: function addRoute(name, route) {
            var override = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

            if (typeof name === 'string' && typeof route === 'string') {
                if (typeof this.getRoutes[name] !== 'undefined') {
                    if (override) {
                        this._routes[name] = route;
                    } else {
                        console.warn('Tried to override route \'' + name + '\' => \'' + route + '\'');
                    }
                } else {
                    this._routes[name] = route;
                }
            }
        }
    }, {
        key: 'getRoute',
        value: function getRoute(key) {
            if (key in this.getRoutes) {
                return this.getRoutes[key];
            }

            return '/';
        }
    }, {
        key: 'thinsp',


        /*************************************
         * Layout Helper
         */
        value: function thinsp() {
            var unit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

            return '<span class="thinsp"><span>&nbsp;</span></span>' + this.getAbbrHtml(unit);
        }
    }, {
        key: 'numberFormatAbbr',
        value: function numberFormatAbbr() {
            var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var unit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
            var decimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 2;
            var decimalsFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 2;

            var formats = {
                '1000000000000000': '<abbr title="Billiarden">Brd.</abbr>',
                '1000000000000': '<abbr title="Billionen">Bio.</abbr>',
                '1000000000': '<abbr title="Milliarde">Mrd.</abbr>',
                '1000000': '<abbr title="Millionen">Mio.</abbr>',
                '1000': '<abbr title="Tausend">Tsd.</abbr>'
            };
            var thinsp = this.thinsp();
            var formatedNumber = '';
            $.each(formats, function (key) {
                if (value >= parseInt(key)) {
                    var rounded = Booyah.roundNumber(value / parseInt(key), decimalsFormat);
                    if (rounded > value / key) {
                        rounded -= Math.pow(10, -decimalsFormat);
                    }

                    formatedNumber = Booyah.numberFormatEU(rounded, decimals) + thinsp + formats[key];
                }
            });
            if (formatedNumber !== '') {
                return formatedNumber;
            }

            return Booyah.numberFormatEU(value, decimals);
        }
    }, {
        key: 'getThemeColorRand',
        get: function get() {
            var keys = Object.keys(this.themeColors);
            var key = keys[Math.floor(Math.random() * (keys.length - 1))];
            return this.getThemeColor(key);
        }
    }, {
        key: 'getAbbrevations',
        get: function get() {
            return this._abbrevations;
        }
    }, {
        key: 'setRoutes',


        /*************************************
         * ROUTES (AJAX)
         */

        set: function set(routes) {
            this._routes = routes;
        }
    }, {
        key: 'getRoutes',
        get: function get() {
            return this._routes;
        }
    }], [{
        key: 'getFormData',
        value: function getFormData(serializedArr, name, valueKey) {
            if (typeof name === 'undefined') {
                return null;
            }
            if (typeof valueKey === 'undefined') {
                valueKey = 'value';
            }
            if (typeof serializedArr[name] !== 'undefined') {
                return serializedArr[name];
            }
            var data = [];
            $.each(serializedArr, function (key, element) {
                if (element.name === name) {
                    data.push(element[valueKey]);
                }
            });
            return data.join(',');
        }
    }, {
        key: 'dateWithOffset',


        /**************************************
         * DATES
         */
        value: function dateWithOffset(datestring) {
            var date = new Date(datestring);
            var offset = new Date().getTimezoneOffset();

            return new Date(date.getTime() - offset * 60 * 1000);
        }
    }, {
        key: 'getDateString',
        value: function getDateString(date) {
            var month = date.getMonth() + 1;
            month = month < 10 ? '0' + month : month;
            var day = date.getDate();
            day = day < 10 ? '0' + day : day;
            return date.getFullYear() + '-' + month + '-' + day + ' 00:00:00';
        }
    }, {
        key: 'roundNumber',
        value: function roundNumber(value, decimals) {
            return Math.round(value * Math.pow(10, decimals)) / Math.pow(10, decimals);
        }
    }, {
        key: 'numberFormatEU',
        value: function numberFormatEU(number, decimals) {
            return this.roundNumber(number, decimals).toString().replace('.', ',');
        }
    }, {
        key: 'formatMelo',
        value: function formatMelo() {
            var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

            if (id.length === 33) {
                var seperator = Booyah.locale === 'at' ? '&nbsp;' : '.';
                var formatedId = id.substr(0, 2) + seperator;
                formatedId += id.substr(2, 6) + seperator;
                formatedId += id.substr(8, 5) + seperator;
                formatedId += id.substr(13) + seperator;

                return formatedId;
            }
            return id;
        }
    }, {
        key: 'toggleCardLoader',
        value: function toggleCardLoader($card) {
            if ($card.is('.loading')) {
                $card.find('.card-loader').remove();
            } else {
                $card.append('<span class="card-loader"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i></span>');
            }
            $card.toggleClass('loading');
        }
    }, {
        key: 'imageToBase64',


        /**
         * IMAGE HELPER
         */
        value: function imageToBase64(img) {
            if (!img.length) {
                return '';
            }

            $('body').prepend('<canvas id="base64canvas"></canvas>');

            var canvas = document.getElementById("base64canvas");
            canvas.width = img.width();
            canvas.height = img.height();

            var ctx = canvas.getContext("2d");
            ctx.drawImage(img.get(0), 0, 0, img.width(), img.height());

            $('body').find('#base64canvas').remove();

            return canvas.toDataURL("image/png");
        }
    }, {
        key: 'elementInViewport',
        value: function elementInViewport(element) {
            var el = $(element)[0];
            var rect = el.getBoundingClientRect();
            return rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight || $(window).height()) && rect.right <= (window.innerWidth || document.documentElement.clientWidth || $(window).width());
        }
    }, {
        key: 'toClipboard',
        value: function toClipboard() {
            var copyText = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

            $('body').prepend('<textarea id="booyah__to-clipboard--field">' + copyText + '</textarea>');
            $('#booyah__to-clipboard--field').get(0).select();
            document.execCommand("copy");
            $('#booyah__to-clipboard--field').remove();
        }
    }, {
        key: 'getAllDaysOfMonth',
        value: function getAllDaysOfMonth(date, format) {
            var lastDay = parseInt(date.clone().endOf('month').format('D'));
            var dateArray = [];
            for (var day = 1; day <= lastDay; day++) {
                date.date(day);
                dateArray.push(date.format(format));
            }

            return dateArray;
        }
    }, {
        key: 'getAllDaysOfYear',
        value: function getAllDaysOfYear(date, format) {
            var dateArray = [];
            for (var month = 0; month <= 11; month++) {
                date.month(month);
                var daysOfMonth = parseInt(date.clone().endOf('month').format('D'));
                for (var day = 1; day <= daysOfMonth; day++) {
                    date.date(day);
                    dateArray.push(date.format(format));
                }
            }

            return dateArray;
        }
    }, {
        key: 'undefinedToZero',
        value: function undefinedToZero(val) {
            if (typeof val === 'undefined') return 0;
            return val;
        }
    }, {
        key: 'ifIsInTo',
        value: function ifIsInTo(val, arr, to) {
            if ($.inArray(val, arr) !== -1) return to;
            return val;
        }
    }, {
        key: 'strBeginsWith',
        value: function strBeginsWith(str, search) {
            return str.trim().indexOf(search.trim()) === 0;
        }
    }, {
        key: 'colorIsHex',
        value: function colorIsHex(colorString) {
            return Booyah.strBeginsWith(colorString.trim(), '#');
        }
    }, {
        key: 'colorIsRgb',
        value: function colorIsRgb(colorString) {
            return Booyah.strBeginsWith(colorString.trim(), 'rgb');
        }
    }, {
        key: 'redundantArray',
        value: function redundantArray(item, count) {
            var reduntantArr = [];
            for (var i = 0; i < count; i++) {
                reduntantArr.push(item);
            }
            return reduntantArr;
        }
    }, {
        key: 'ucFirst',
        value: function ucFirst(word) {
            return word.charAt(0).toUpperCase() + word.slice(1);
        }
    }, {
        key: 'objectsEqual',
        value: function objectsEqual() {
            var equals = true;
            if (arguments.length < 2) {
                throw new TypeError('Cannot compare nothing.');
            }
            for (var i = 0; i < arguments.length; i++) {
                if (_typeof(arguments[i]) !== 'object' || arguments[i] === null) {
                    throw new TypeError('Cannot compare when one of the objects is null or undefined.');
                }
            }
            var oldObject = arguments[0];
            for (var _i = 1; _i < arguments.length; _i++) {
                var objetToCompareWithOld = arguments[_i];
                var keysObj = Object.keys(oldObject);
                var keysObj2 = Object.keys(objetToCompareWithOld);
                var equalKeys = keysObj.toString() === keysObj2.toString();
                if (equalKeys) {
                    for (var _i2 = 0; _i2 < keysObj.length; _i2++) {
                        if (_typeof(oldObject[keysObj[_i2]]) !== _typeof(objetToCompareWithOld[keysObj[_i2]])) {
                            equals = false;
                        } else {
                            if (_typeof(oldObject[keysObj[_i2]]) === 'object') {
                                equals = Booyah.objectsEqual(oldObject[keysObj[_i2]], objetToCompareWithOld[keysObj[_i2]]);
                            } else {
                                equals = oldObject[keysObj[_i2]] === objetToCompareWithOld[keysObj[_i2]];
                            }
                        }
                        if (!equals) {
                            break;
                        }
                    }
                    if (!equals) {
                        break;
                    }
                } else {
                    equals = false;
                    break;
                }
                oldObject = objetToCompareWithOld;
            }

            return equals;
        }
    }, {
        key: 'objectGet',
        value: function objectGet(searchVal, object, defaultVal) {
            var result = object;
            var keys = [];
            if (typeof searchVal === 'string') {
                keys = searchVal.split('.');
            } else if ((typeof searchVal === 'undefined' ? 'undefined' : _typeof(searchVal)) === 'object') {
                keys = searchVal;
            }
            for (var i = 0; i < keys.length; i++) {
                if (typeof result[keys[i]] === 'undefined') {
                    result = defaultVal;
                    break;
                }
                result = result[keys[i]];
            }

            return result;
        }
    }, {
        key: 'locale',
        get: function get() {
            return $('html').attr('lang');
        }
    }, {
        key: 'currentBreakpoint',
        get: function get() {
            return getComputedStyle($('body').get(0)).getPropertyValue('--breakpoint');
        }
    }, {
        key: 'randomId',


        /**
         * COMMON HELPER
         */
        get: function get() {
            var tmpId = void 0;
            do {
                tmpId = Math.random().toString(12).substr(2);
            } while ($('#' + tmpId).length > 0);

            return tmpId;
        }
    }, {
        key: 'getActiveTab',
        get: function get() {
            if (typeof window.location.hash !== 'undefined') {
                return window.location.hash.substr(1);
            }

            return '';
        }
    }]);

    return Booyah;
}();

var booyah = new Booyah();

// -----------------------------------------------------------------------------
// Masonry

$('.row.masonry').masonry({
    itemSelector: '.mas-col',
    columnWidth: '.masonry-sizer',
    percentPosition: true
});

// -----------------------------------------------------------------------------
// Popovers

$('[data-toggle="popover"]').popover();

// -----------------------------------------------------------------------------
// Tooltips

$('[data-toggle="tooltip"]').tooltip({
    trigger: 'hover'
});

// -----------------------------------------------------------------------------
// Confirmation

$('[data-confirm="confirmation"]').confirmation({
    rootSelector: '[data-toggle="confirmation"]',
    title: 'Sind Sie sicher?',
    btnOkLabel: 'Ja',
    btnCancelLabel: 'Nein',
    popout: true
});

// -----------------------------------------------------------------------------
// Equalize

booyah.$.equalize = {};
booyah.$.equalize.groups = [];
booyah.$.equalize.set = function () {
    var mediaPrefix = Booyah.currentBreakpoint;
    var groupName, groupMedia, elemHeight, maxHeight;
    $("[data-equal-height]").each(function () {
        groupName = $(this).data("equal-height");
        if ($.inArray(groupName, booyah.$.equalize.groups) === -1) {
            booyah.$.equalize.groups.push(groupName);
        }
    });
    $.each(booyah.$.equalize.groups, function (i, groupName) {
        elemHeight = 0;
        maxHeight = 0;
        $("[data-equal-height='" + groupName + "']").height("").filter(function () {
            groupMedia = $(this).data("equal-height-bp");
            if (typeof groupMedia === "undefined") {
                return true;
            } else {
                return $.inArray(mediaPrefix, groupMedia.split(',')) !== -1;
            }
        }).each(function () {
            elemHeight = $(this).height();
            if (elemHeight > maxHeight) {
                maxHeight = elemHeight;
            }
        }).height(maxHeight);
    });
};

booyah.$.equalize.set();

$(window).on("load resize", function () {
    booyah.$.equalize.set();
});

// -----------------------------------------------------------------------------
// Equalize Groups

booyah.$.equalizeGroups = $('.booyah-eq');
booyah.$.equalizeGroups.runEq = function ($rowObjects) {
    if ($rowObjects.find('[data-eq-part]').length) {
        var eqPartKeys = [];
        $rowObjects.find('[data-eq-part]').each(function () {
            var eqPart = $(this).data('eq-part');
            if ($.inArray(eqPart, eqPartKeys) === -1) {
                eqPartKeys.push(eqPart);
            }
        });
        var eqPartGroups = [];
        $rowObjects.find('[data-eq-part-group]').each(function () {
            var eqGroup = $(this).data('eq-part-group');
            if ($.inArray(eqGroup, eqPartGroups) === -1) {
                eqPartGroups.push(eqGroup);
            }
        });
        $.each(eqPartKeys, function (inx, key) {
            var minHeight = 0;
            $rowObjects.find('[data-eq-part="' + key + '"]').each(function (inx) {
                if ($(this).outerHeight() > minHeight) {
                    minHeight = $(this).outerHeight();
                }
            });
            $rowObjects.find('[data-eq-part="' + key + '"]').css('min-height', minHeight + 'px');
        });
        $.each(eqPartGroups, function (inx, group) {
            var groupKeys = group.split(',');
            var minHeight = 0;
            $.each(groupKeys, function (i, key) {
                minHeight += $rowObjects.find('[data-eq-part="' + key + '"]').first().outerHeight();
            });
            $rowObjects.find('[data-eq-part-group="' + group + '"]').css('min-height', minHeight + 'px');
            var groupMaxHeight = 0;
            $rowObjects.find('[data-eq-part-group="' + group + '"]').each(function () {
                if ($(this).outerHeight() > groupMaxHeight && $(this).outerHeight() > minHeight) {
                    groupMaxHeight = $(this).outerHeight();
                }
            });
            if (groupMaxHeight > 0) {
                $rowObjects.find('[data-eq-part-group="' + group + '"]').css('min-height', groupMaxHeight + 'px');
                $rowObjects.each(function () {
                    var $obj = $(this);
                    var $parts = $obj.find('[data-eq-part]').filter(function () {
                        return $.inArray($(this).data('eq-part'), groupKeys) !== -1;
                    });
                    var partsHeight = 0;
                    var $firstPart = $parts.filter('[data-eq-part="' + groupKeys[0] + '"]');
                    if ($parts.length === groupKeys.length) {
                        $parts.each(function () {
                            partsHeight += $(this).outerHeight();
                        });
                        if (partsHeight < groupMaxHeight) {
                            $firstPart.css('min-height', $firstPart.outerHeight() + (groupMaxHeight - partsHeight) + 'px');
                        }
                    }
                });
            }
        });
    } else {
        var minHeight = 0;
        $rowObjects.each(function () {
            if ($(this).outerHeight() > minHeight) {
                minHeight = $(this).outerHeight();
            }
        });
        $rowObjects.css('min-height', minHeight + 'px');
    }
    $rowObjects.addClass('eq-runned');
};

booyah.$.equalizeGroups.run = function () {
    this.each(function () {
        var $container = $(this);
        var $objects = $container.find('.eq-object');
        $objects.removeClass('eq-runned');
        if (!$objects.find('[data-eq-part]').length) {
            $objects.css('min-height', '');
        } else {
            $objects.find('[data-eq-part]').css('min-height', '');
        }

        var _loop = function _loop() {
            var $firstOfRow = $objects.filter(function () {
                return !$(this).hasClass('eq-runned');
            }).first();
            var rect = $firstOfRow.get(0).getBoundingClientRect();
            var top = rect.top;
            var $rowObjects = $objects.filter(function () {
                var objRect = this.getBoundingClientRect();
                var objTop = objRect.top;
                return objTop >= top - 16 && objTop <= top + 16;
            });
            booyah.$.equalizeGroups.runEq($rowObjects);
        };

        while ($objects.filter('.eq-runned').length < $objects.length) {
            _loop();
        }
    });
};

booyah.$.equalizeGroups.run();
$(window).on("load resize rungroupeq", function () {
    booyah.$.equalizeGroups.run();
});

// -----------------------------------------------------------------------------
// Custom File Select

booyah.$.$customFileSelects = $('.custom-file');
booyah.$.$customFileSelects.each(function () {
    $(this).find('input').on('change', function () {
        var filename = $(this).val();
        $(this).next('label').text(filename.replace(/.*[\/\\]/, ''));
    });
});

// -----------------------------------------------------------------------------
// Random Background

booyah.$.$bgRand = $('.booyah-random-bg');
booyah.$.$bgRand.each(function () {
    $(this).css('background-color', booyah.getThemeColorRand);
});

// -----------------------------------------------------------------------------
// Sidebar

booyah.$.$pageSidebar = $('.page-sidebar');

if (booyah.$.$pageSidebar.length) {

    booyah.$.$pageSidebar.$nav = booyah.$.$pageSidebar.find('.sidebar-nav');
    booyah.$.$pageSidebar.$nav.$subnavs = booyah.$.$pageSidebar.$nav.find('.sidebar-subnav');
    booyah.$.$pageSidebar.$nav.$subnavToggleButtons = booyah.$.$pageSidebar.$nav.find('button');

    booyah.$.$pageSidebar.$nav.$subnavToggleButtons.on('click', function () {
        var $button = $(this);
        var $parentNav_item = $button.closest('li');
        var $subnavs = booyah.$.$pageSidebar.$nav.$subnavs;
        var $subnav_affected = $button.next($subnavs);
        var $subnavs_other = $subnavs.not($subnav_affected);
        var toggleMode = $parentNav_item.is('.expanded') ? 'hide' : 'show';
        booyah.$.$pageSidebar.$nav.toggleSubnavs($subnav_affected, toggleMode);
        booyah.$.$pageSidebar.$nav.toggleSubnavs($subnavs_other, 'hide');
    });

    booyah.$.$pageSidebar.$nav.toggleSubnavs = function ($subnavs, mode) {
        var animation_done_css = {
            'height': '',
            'padding': '',
            'margin': ''
        };
        var $subnav = void 0,
            $subnav_list = void 0,
            $parentNav_item = void 0;
        $subnavs.each(function (i, subnav) {
            $subnav = $(subnav);
            $subnav_list = $subnav.find('> ul');
            $parentNav_item = $subnav.closest('li');
            $subnav_list.stop();
            if (mode === 'show') {
                $parentNav_item.addClass('expanded');
                $subnav_list.slideDown(function () {
                    $(this).css(animation_done_css);
                });
            } else {
                $parentNav_item.removeClass('expanded');
                $subnav_list.slideUp(function () {
                    $(this).css(animation_done_css);
                });
            }
        });
    };

    // Mobil - Toggel

    booyah.$.$pageSidebar.toggleButton = $('.btn--toggle-sidebar');
    booyah.$.$pageSidebar.toggleButton.on('click', function () {
        booyah.$.$pageSidebar.toggleVisibility();
    });

    booyah.$.$pageSidebar.toggleVisibility = function () {
        if ($('body').hasClass('sidebar-hidden')) {
            $('body').removeClass('sidebar-hidden');
        } else {
            $('body').addClass('sidebar-hidden');
        }
    };

    booyah.$.$pageSidebar.navToggelButton = $('#toggel-navbar');

    booyah.$.$pageSidebar.navToggelButton.on('click', function () {
        booyah.$.$pageSidebar.toggleClass('mobile-nav');
    });

    booyah.$.$pageSidebar.toggleMobile = function () {
        if ($.inArray(Booyah.currentBreakpoint, ['md', 'sm', 'xs']) < 0) {
            $('body').removeClass('sidebar-hidden');
        } else {
            $('body').addClass('sidebar-hidden');
        }
    };

    $(window).on('ready load', function () {
        booyah.$.$pageSidebar.toggleMobile();
    });

    $('.nav-active-line .nav-item a').on('click', function () {
        var li = $(this).parents('li');
        if (!li.hasClass('active')) {
            $(this).parents('ul').find('li.active').removeClass('active');
            li.addClass('active');
        }
    });
}
