<?php

use Illuminate\Support\Facades\File;

if (! function_exists('get_theme_config_arr')) {
    function get_theme_config_arr()
    {
        $themeName = env('THEME_NAME');
        $themePathExists = File::exists(public_path() . '/assets/themes/' . $themeName);
        if (blank($themeName) || ! theme_enabled() || ! $themePathExists) {
            $themeName = 'default';
        }
        $configFileExists = File::exists(public_path() . '/assets/themes/' . $themeName . '/config.json');
        if ($configFileExists) {
            $config = File::get(public_path() . '/assets/themes/' . $themeName . '/config.json');
            return json_decode($config, true);
        }

        return [];
    }
}

if (! function_exists('theme_config')) {
    function theme_config($key, $default = null)
    {
        return array_get(get_theme_config_arr(), $key, $default);
    }
}