// -----------------------------------------------------------------------------
// Masonry

$('.row.masonry').masonry({
    itemSelector: '.mas-col',
    columnWidth: '.masonry-sizer',
    percentPosition: true
});

// -----------------------------------------------------------------------------
// Popovers

$('[data-toggle="popover"]').popover();

// -----------------------------------------------------------------------------
// Tooltips

$('[data-toggle="tooltip"]').tooltip({
    trigger: 'hover'
});

// -----------------------------------------------------------------------------
// Confirmation

$('[data-confirm="confirmation"]').confirmation({
    rootSelector: '[data-toggle="confirmation"]',
    title: 'Sind Sie sicher?',
    btnOkLabel: 'Ja',
    btnCancelLabel: 'Nein',
    popout: true
});

// -----------------------------------------------------------------------------
// Equalize

booyah.$.equalize = {};
booyah.$.equalize.groups = [];
booyah.$.equalize.set = function () {
    var mediaPrefix = Booyah.currentBreakpoint;
    var groupName, groupMedia, elemHeight, maxHeight;
    $("[data-equal-height]").each(function () {
        groupName = $(this).data("equal-height");
        if ($.inArray(groupName, booyah.$.equalize.groups) === - 1) {
            booyah.$.equalize.groups.push(groupName);
        }
    });
    $.each(booyah.$.equalize.groups, function (i, groupName) {
        elemHeight = 0;
        maxHeight = 0;
        $("[data-equal-height='" + groupName + "']").height("").filter(function () {
            groupMedia = $(this).data("equal-height-bp");
            if (typeof groupMedia === "undefined") {
                return true;
            } else {
                return $.inArray(mediaPrefix, groupMedia.split(',')) !== - 1;
            }
        }).each(function () {
            elemHeight = $(this).height();
            if (elemHeight > maxHeight) {
                maxHeight = elemHeight;
            }
        }).height(maxHeight);
    });
};

booyah.$.equalize.set();

$(window).on("load resize", function () {
    booyah.$.equalize.set();
});

// -----------------------------------------------------------------------------
// Equalize Groups

booyah.$.equalizeGroups = $('.booyah-eq');
booyah.$.equalizeGroups.runEq = function ($rowObjects) {
    if ($rowObjects.find('[data-eq-part]').length) {
        let eqPartKeys = [];
        $rowObjects.find('[data-eq-part]').each(function () {
            let eqPart = $(this).data('eq-part');
            if ($.inArray(eqPart, eqPartKeys) === - 1) {
                eqPartKeys.push(eqPart);
            }
        });
        let eqPartGroups = [];
        $rowObjects.find('[data-eq-part-group]').each(function () {
            let eqGroup = $(this).data('eq-part-group');
            if ($.inArray(eqGroup, eqPartGroups) === - 1) {
                eqPartGroups.push(eqGroup);
            }
        });
        $.each(eqPartKeys, function (inx, key) {
            let minHeight = 0;
            $rowObjects.find('[data-eq-part="' + key + '"]').each(function (inx) {
                if ($(this).outerHeight() > minHeight) {
                    minHeight = $(this).outerHeight();
                }
            });
            $rowObjects.find('[data-eq-part="' + key + '"]').css('min-height', minHeight + 'px');
        });
        $.each(eqPartGroups, function (inx, group) {
            let groupKeys = group.split(',');
            let minHeight = 0;
            $.each(groupKeys, function (i, key) {
                minHeight += $rowObjects.find('[data-eq-part="' + key + '"]').first().outerHeight();
            });
            $rowObjects.find('[data-eq-part-group="' + group + '"]').css('min-height', minHeight + 'px');
            let groupMaxHeight = 0;
            $rowObjects.find('[data-eq-part-group="' + group + '"]').each(function () {
                if ($(this).outerHeight() > groupMaxHeight && $(this).outerHeight() > minHeight) {
                    groupMaxHeight = $(this).outerHeight();
                }
            });
            if (groupMaxHeight > 0) {
                $rowObjects.find('[data-eq-part-group="' + group + '"]').css('min-height', groupMaxHeight + 'px');
                $rowObjects.each(function () {
                    let $obj = $(this);
                    let $parts = $obj.find('[data-eq-part]').filter(function () {
                        return $.inArray($(this).data('eq-part'), groupKeys) !== - 1;
                    });
                    let partsHeight = 0;
                    let $firstPart = $parts.filter('[data-eq-part="' + groupKeys[0] + '"]');
                    if ($parts.length === groupKeys.length) {
                        $parts.each(function () {
                            partsHeight += $(this).outerHeight();
                        });
                        if (partsHeight < groupMaxHeight) {
                            $firstPart.css('min-height', ($firstPart.outerHeight() + (groupMaxHeight - partsHeight)) + 'px');
                        }
                    }
                });
            }
        });
    } else {
        let minHeight = 0;
        $rowObjects.each(function () {
            if ($(this).outerHeight() > minHeight) {
                minHeight = $(this).outerHeight();
            }
        });
        $rowObjects.css('min-height', minHeight + 'px');
    }
    $rowObjects.addClass('eq-runned');
};

booyah.$.equalizeGroups.run = function () {
    this.each(function () {
        let $container = $(this);
        let $objects = $container.find('.eq-object');
        $objects.removeClass('eq-runned');
        if (! $objects.find('[data-eq-part]').length) {
            $objects.css('min-height', '');
        } else {
            $objects.find('[data-eq-part]').css('min-height', '');
        }
        while ($objects.filter('.eq-runned').length < $objects.length) {
            let $firstOfRow = $objects.filter(function () {
                return ! $(this).hasClass('eq-runned');
            }).first();
            let rect = $firstOfRow.get(0).getBoundingClientRect();
            let top = rect.top;
            let $rowObjects = $objects.filter(function () {
                let objRect = this.getBoundingClientRect();
                let objTop = objRect.top;
                return (objTop >= top - 16 && objTop <= top + 16);
            });
            booyah.$.equalizeGroups.runEq($rowObjects);
        }
    });
};

booyah.$.equalizeGroups.run();
$(window).on("load resize rungroupeq", function () {
    booyah.$.equalizeGroups.run();
});

// -----------------------------------------------------------------------------
// Custom File Select

booyah.$.$customFileSelects = $('.custom-file');
booyah.$.$customFileSelects.each(function () {
    $(this).find('input').on('change', function () {
        let filename = $(this).val();
        $(this).next('label').text(filename.replace(/.*[\/\\]/, ''));
    });
});

// -----------------------------------------------------------------------------
// Random Background

booyah.$.$bgRand = $('.booyah-random-bg');
booyah.$.$bgRand.each(function () {
    $(this).css('background-color', booyah.getThemeColorRand);
});
