bocc.$loadProfiles.statistics = $('.card--load-profiles .statistics');

if (bocc.$loadProfiles.statistics.length > 0) {

    bocc.$loadProfiles.statistics.demoData = {
        'DE1234567890123456789012345678901': {
            'consumption': 123456,
            'maxi': [
                {
                    'value': 12345,
                    'date': '2018-01-01 14:45'
                },
                {
                    'value': 12340,
                    'date': '2018-01-01 14:30'
                },
                {
                    'value': 12335,
                    'date': '2018-01-01 14:15'
                },
                {
                    'value': 12330,
                    'date': '2018-01-01 14:00'
                },
                {
                    'value': 12240,
                    'date': '2018-01-01 12:30'
                }
            ],
            'mini': [
                {
                    'value': 10,
                    'date': '2018-02-01 14:45'
                },
                {
                    'value': 7,
                    'date': '2018-02-03 14:45'
                },
                {
                    'value': 5,
                    'date': '2018-02-05 14:45'
                },
                {
                    'value': 2,
                    'date': '2018-02-04 14:45'
                },
                {
                    'value': 1,
                    'date': '2018-02-02 14:45'
                }
            ]
        },
        'DE1234567890123456789012345678902': {
            'consumption': 123458,
            'maxi': [
                {
                    'value': 12345,
                    'date': '2018-01-01 14:45'
                },
                {
                    'value': 12340,
                    'date': '2018-01-01 14:30'
                },
                {
                    'value': 12335,
                    'date': '2018-01-01 14:15'
                },
                {
                    'value': 12330,
                    'date': '2018-01-01 14:00'
                },
                {
                    'value': 12240,
                    'date': '2018-01-01 12:30'
                }
            ],
            'mini': [
                {
                    'value': 10,
                    'date': '2018-02-01 14:45'
                },
                {
                    'value': 7,
                    'date': '2018-02-03 14:45'
                },
                {
                    'value': 5,
                    'date': '2018-02-05 14:45'
                },
                {
                    'value': 2,
                    'date': '2018-02-04 14:45'
                },
                {
                    'value': 1,
                    'date': '2018-02-02 14:45'
                }
            ]
        }
    };

    bocc.$loadProfiles.statistics.loadData = function () {
        var config = bocc.$loadProfiles.getConfig();
        var ajaxUrl = bocc.getAjaxRoute('ajax.customer.loadprofiles.statistics');
        if (bocc.getFormData(config, 'alternative') !== 'yes') {
            $.post(ajaxUrl, {
                start: bocc.getFormData(config, 'start'),
                end: bocc.getFormData(config, 'end'),
                objects: bocc.getFormData(config, 'objects_' + bocc.getFormData(config, 'energy_type') + '[]'),
                kpi: bocc.getFormData(config, 'kpi'),
                resolution: bocc.getFormData(config, 'resolution'),
                energy_type: bocc.getFormData(config, 'energy_type'),
                show_blind: bocc.getFormData(config, 'show_blind'),
                direction: bocc.getFormData(config, 'reading_direction')
            }).done(function (response) {
                bocc.$loadProfiles.statistics.update(response);
            });
        } else {
            format = bocc.$loadProfiles.getDateFormat();
            var firstStart = moment(bocc.$loadProfiles.$control.$alternativeFirst[0].val(), format).locale(bocc.locale());
            var secondStart = moment(bocc.$loadProfiles.$control.$alternativeSecond[0].val(), format).locale(bocc.locale());

            var firstEnd, secondEnd;
            switch (bocc.getFormData(config, 'alternative_timerange')) {
                case 'year':
                    firstEnd = firstStart.clone().endOf('year');
                    secondEnd = secondStart.clone().endOf('year');
                    break;
                case 'month':
                    firstEnd = firstStart.clone().endOf('month');
                    secondEnd = secondStart.clone().endOf('month');
                    break;
                default:
                    firstEnd = firstStart.clone().endOf('day');
                    secondEnd = secondStart.clone().endOf('day');
            }
            data = {
                key: bocc.getFormData(config, 'objects_' + bocc.getFormData(config, 'energy_type') + '[]'),
                times: {
                    first: {
                        start: firstStart,
                        end: firstEnd
                    },
                    second: {
                        start: secondStart,
                        end: secondEnd
                    }
                }
            };
            $.post(ajaxUrl, {
                start: firstStart.format(format),
                end: firstEnd.format(format),
                objects: bocc.getFormData(config, 'objects_' + bocc.getFormData(config, 'energy_type') + '[]'),
                kpi: bocc.getFormData(config, 'kpi'),
                resolution: bocc.getFormData(config, 'resolution'),
                energy_type: bocc.getFormData(config, 'energy_type'),
                show_blind: bocc.getFormData(config, 'show_blind'),
                direction: bocc.getFormData(config, 'reading_direction')
            }).done(function (response) {
                data.first = response;
                $.post(ajaxUrl, {
                    start: secondStart.format(format),
                    end: secondEnd.format(format),
                    objects: bocc.getFormData(config, 'objects_' + bocc.getFormData(config, 'energy_type') + '[]'),
                    kpi: bocc.getFormData(config, 'kpi'),
                    resolution: bocc.getFormData(config, 'resolution'),
                    energy_type: bocc.getFormData(config, 'energy_type'),
                    show_blind: bocc.getFormData(config, 'show_blind'),
                    direction: bocc.getFormData(config, 'reading_direction')
                }).done(function (response) {
                    data.second = response;
                    bocc.$loadProfiles.statistics.updateCompare(data);
                });
            });
        }
    };

    bocc.$loadProfiles.$configForm.on('submit', bocc.$loadProfiles.statistics.loadData);

    bocc.$loadProfiles.statistics.update = function (data) {
        var objectRow = bocc.$loadProfiles.statistics.find('.after-row.name')
        var dataRow = bocc.$loadProfiles.statistics.find('.after-row.data')
        var dataToAppend = '';
        bocc.$loadProfiles.statistics.find('.statistics-table tbody').html(dataToAppend);
        $.each(data, function (key, value) {
            var alias = bocc.$loadProfiles.getObjectAliasById(key);
            var rowObject = $.extend({}, objectRow);
            var minLength = value.mini.length - 1;
            var maxLength = value.maxi.length - 1;

            var small = '';

            if (key.length === 11) {
                small += 'MaLo-ID: ';
            } else if (key.length === 33) {
                small += 'MeLo-ID: ';
            }

            small += bocc.formatMelo(key);

            $(rowObject.find('td').get(0)).html('<h5 class="weight-xs-7 object-id mg-b-xs-25">' + alias + '<br><small>' + small + '</small></h5>');
            dataToAppend += '<tr>' + rowObject.html() + '</tr>';

            if (minLength < 0 && maxLength < 0 && value.consumption === 0) {
                dataToAppend += '<tr><td colspan="4">Keine Daten</td></tr>';
                return true;
            }

            maxSize = minLength >= maxLength ? minLength : maxLength;
            for (counter = 0; counter < maxSize; counter ++) {
                var rowData = $.extend({}, dataRow);
                if (counter === 0) {
                    rowData.find('td.usage').html(AmCharts.formatNumber(Math.abs(value.consumption), {
                        precision: 2,
                        decimalSeparator: ',',
                        thousandsSeparator: '.'
                    }) + bocc.thinsp('kWh'));
                } else {
                    rowData.find('td.usage').text('');
                }
                if (maxLength >= counter) {
                    html = AmCharts.formatNumber(Math.abs(value.maxi[counter].value), {
                        precision: 2,
                        decimalSeparator: ',',
                        thousandsSeparator: '.'
                    }) + bocc.thinsp('kW') + '<br><small>' + value.maxi[counter].date + '</small>';
                    rowData.find('td.high').html(html);
                }
                if (minLength >= counter) {
                    html = AmCharts.formatNumber(Math.abs(value.mini[counter].value), {
                        precision: 2,
                        decimalSeparator: ',',
                        thousandsSeparator: '.'
                    }) + bocc.thinsp('kW') + '<br><small>' + value.mini[counter].date + '</small>';
                    rowData.find('td.lowest').html(html);
                }

                dataToAppend += '<tr>' + rowData.html() + '</tr>';
                if (counter < maxSize - 1) {
                    dataToAppend += '<tr></tr>';
                }
            }
        });
        bocc.$loadProfiles.statistics.find('.statistics-table tbody').html(dataToAppend);
    };


    bocc.$loadProfiles.statistics.updateCompare = function (data) {
        var objectRow = bocc.$loadProfiles.statistics.find('.after-row.name')
        var dataRow = bocc.$loadProfiles.statistics.find('.after-row.data')

        // Clear Old
        var dataToAppend = '';
        bocc.$loadProfiles.statistics.find('.statistics-table tbody').html(dataToAppend);

        //Kopf Zeile
        var alias = bocc.$loadProfiles.getObjectAliasById(data.key);
        var small = '';
        if (data.key.length === 11) {
            small += 'MaLo-ID: ';
        } else if (data.key.length === 33) {
            small += 'MeLo-ID: ';
        }
        small += bocc.formatMelo(data.key);
        var rowObject = $.extend({}, objectRow);
        $(rowObject.find('td').get(0)).html('<h5 class="weight-xs-7 object-id mg-b-xs-25">' + alias + '<br><small>' + small + '</small></h5>');
        dataToAppend += '<tr>' + rowObject.html() + '</tr><tr></tr>';

        var format = bocc.$loadProfiles.getDateFormat();

        $.each(['first', 'second'], function (k, number) {
            var tObject = $.extend({}, objectRow);
            var start = data.times[number].start.format(format);
            var end = data.times[number].end.format(format);
            $(tObject.find('td').get(0)).html('<span class="weight-xs-7 mg-b-xs-25">' + start + ' &ndash; ' + end + '</span>');
            dataToAppend += '<tr>' + rowObject.html() + '</tr>';
            $.each(data[number], function (key, value) {

                var minLength = value.mini.length;
                var maxLength = value.maxi.length;

                if (minLength === 0 && maxLength === 0 && value.consumption === 0) {
                    dataToAppend += '<tr><td colspan="4">Keine Daten</td></tr>';
                    return true;
                }

                var maxSize = minLength >= maxLength ? minLength : maxLength;
                var html = '';
                for (var counter = 0; counter < maxSize; counter ++) {
                    var rowData = $.extend({}, dataRow);
                    if (counter === 0) {
                        rowData.find('td.usage').html(AmCharts.formatNumber(Math.abs(value.consumption), {
                            precision: 2,
                            decimalSeparator: ',',
                            thousandsSeparator: '.'
                        }) + bocc.thinsp('kWh'));
                    } else {
                        rowData.find('td.usage').text('');
                    }
                    if (maxLength >= counter) {
                        html = AmCharts.formatNumber(Math.abs(value.maxi[counter].value), {
                            precision: 2,
                            decimalSeparator: ',',
                            thousandsSeparator: '.'
                        }) + bocc.thinsp('kW') + '<br><small>' + value.maxi[counter].date + '</small>';
                        rowData.find('td.high').html(html);
                    }
                    if (minLength >= counter) {
                        html = AmCharts.formatNumber(Math.abs(value.mini[counter].value), {
                            precision: 2,
                            decimalSeparator: ',',
                            thousandsSeparator: '.'
                        }) + bocc.thinsp('kW') + '<br><small>' + value.mini[counter].date + '</small>';
                        rowData.find('td.lowest').html(html);
                    }

                    dataToAppend += '<tr>' + rowData.html() + '</tr>';
                    if (counter < maxSize - 1) {
                        dataToAppend += '<tr></tr>';
                    }
                }
            });
        });


        bocc.$loadProfiles.statistics.find('.statistics-table tbody').html(dataToAppend);
    };


    bocc.$loadProfiles.statistics.loadData();
}
