<?php

namespace Redtree\BooyahWebTemplate\Services\Views;

use Illuminate\Support\Facades\File;

class ThemeService
{
    public $name;
    public $path;
    public $publicPath;

    public function __construct()
    {
        $this->setName();
        $this->setPath();
        $this->setPublicPath();
    }

    public function pageExists($file)
    {
        return File::exists($this->publicPath . '/html/pages/' . $file . '.html');
    }

    public function page($file)
    {
        if (! $this->pageExists($file)) {
            return '';
        }

        return File::get($this->publicPath . '/html/pages/' . $file . '.html');
    }

    public function pageInfoExists($component)
    {
        return File::exists($this->publicPath . '/html/info/' . request()->route()->getName() . '/' . $component . '.html');
    }

    public function pageInfo($component)
    {
        return File::get($this->publicPath . '/html/info/' . request()->route()->getName() . '/' . $component . '.html');
    }

    public function pageInfoDisabled()
    {
        $hideThemeInfo = File::exists($this->publicPath . '/html/info/disabled.txt');
        if ($hideThemeInfo) {
            return $hideThemeInfo;
        }

        return File::exists($this->publicPath . '/html/info/' . request()->route()->getName() . '/disabled.txt');
    }

    private function setName()
    {
        $themeName = env('THEME_NAME');
        $themePathExists = File::exists(public_path() . '/assets/themes/' . $themeName);
        if (blank($themeName) || ! theme_enabled() || ! $themePathExists) {
            $themeName = 'default';
        }
        $this->name = $themeName;
    }

    private function setPath()
    {
        $this->path = '/assets/themes/' . $this->name;
    }

    private function setPublicPath()
    {
        $this->publicPath = public_path() . '/assets/themes/' . $this->name;
    }
}
