let mix = require('laravel-mix');

mix.setPublicPath('./');

/************************************************************************************
 * > Booyah Web Template
 */

let booyahWebTemplateBasePath = './';
let booyahWebTemplate = {
    'path': {
        'src': {
            'scss': booyahWebTemplateBasePath + 'resources/assets/scss',
            'js': booyahWebTemplateBasePath + 'resources/assets/js',
            'img': booyahWebTemplateBasePath + 'resources/assets/img',
            'fonts': booyahWebTemplateBasePath + 'resources/assets/fonts',
            'themes': booyahWebTemplateBasePath + 'resources/assets/themes'
        },
        'dist': {
            'css': booyahWebTemplateBasePath + 'dist/assets/css',
            'scss': booyahWebTemplateBasePath + 'dist/assets/scss',
            'js': booyahWebTemplateBasePath + 'dist/assets/js',
            'img': booyahWebTemplateBasePath + 'dist/assets/img',
            'fonts': booyahWebTemplateBasePath + 'dist/assets/fonts',
            'themes': booyahWebTemplateBasePath + 'dist/assets/themes'
        }
    },
    'themes': [
        'default',
        'auew',
        'witten',
        'ehinger'
    ]
};

booyahWebTemplate.resources = {
    'js': {
        'main': [
            booyahWebTemplate.path.src.js + '/booyah-polyfills.js',
            booyahWebTemplate.path.src.js + '/booyah-class.js',
            booyahWebTemplate.path.src.js + '/booyah-layout.js',
            booyahWebTemplate.path.src.js + '/layout/sidebar.js'
        ],
        'vendor': [
            'node_modules/jquery/dist/jquery.js',
            'node_modules/bootstrap/dist/js/bootstrap.bundle.js',
            booyahWebTemplate.path.src.js + '/vendor/bootstrap-datepicker.js',
            booyahWebTemplate.path.src.js + '/vendor/bootstrap-datepicker.de.min.js',
            'node_modules/bootstrap-select-v4/dist/js/bootstrap-select.js',
            booyahWebTemplate.path.src.js + '/vendor/accounting.js',
            'node_modules/dom-to-image/src/dom-to-image.js',
            'node_modules/moment/min/moment.min.js',
            'node_modules/moment/min/locales.js',
            'node_modules/bootstrap-confirmation2/dist/bootstrap-confirmation.min.js',
            booyahWebTemplate.path.src.js + '/vendor/dependsOn.min.js',
            booyahWebTemplate.path.src.js + '/vendor/masonry.pkgd.min.js'
        ],
        'charts': {
            'core': [
                booyahWebTemplate.path.src.js + '/vendor/amcharts/amcharts.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/serial.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/pie.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/amstock.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/plugins/responsive.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/plugins/export.js',
                booyahWebTemplate.path.src.js + '/vendor/amcharts/de.js',
                booyahWebTemplate.path.src.js + '/charts/chart-init-handler.js'
            ],
            'basic': [
                booyahWebTemplate.path.src.js + '/charts/charts-basic.js',
            ]
        }
    }
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Main JS
mix.options({
    uglify: {
        uglifyOptions: {
            keep_fnames: true,
            keep_classnames: true,
            toplevel: false,
            safari10: false,
            ie8: false,
        }
    }
});

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// MAIN JS

if (mix.inProduction()) {
    mix.babel(booyahWebTemplate.resources.js.main, booyahWebTemplate.path.dist.js + '/booyah-main.js')
        .minify(booyahWebTemplate.path.dist.js + '/booyah-main.js');
    mix.scripts(booyahWebTemplate.resources.js.vendor, booyahWebTemplate.path.dist.js + '/booyah-vendor.js')
        .minify(booyahWebTemplate.path.dist.js + '/booyah-vendor.js');
} else {
    mix.babel(booyahWebTemplate.resources.js.main, booyahWebTemplate.path.dist.js + '/booyah-main.js');
    mix.scripts(booyahWebTemplate.resources.js.vendor, booyahWebTemplate.path.dist.js + '/booyah-vendor.js');
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CHART JS

if (mix.inProduction()) {
    mix.scripts(booyahWebTemplate.resources.js.charts.core, booyahWebTemplate.path.dist.js + '/charts/core.js')
        .minify(booyahWebTemplate.path.dist.js + '/charts/core.min.js');
    mix.babel(booyahWebTemplate.resources.js.charts.basic, booyahWebTemplate.path.dist.js + '/charts/basic.js')
        .minify(booyahWebTemplate.path.dist.js  + '/charts/basic.min.js');
} else {
    mix.scripts(booyahWebTemplate.resources.js.charts.core, booyahWebTemplate.path.dist.js + '/charts/core.js');
    mix.babel(booyahWebTemplate.resources.js.charts.basic, booyahWebTemplate.path.dist.js + '/charts/basic.js');
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// THEMES CSS

for (let i = 0; i < booyahWebTemplate.themes.length; i ++) {
    let srcPath = booyahWebTemplate.path.src.themes + '/' + booyahWebTemplate.themes[i] + '/scss/main.scss';
    let distPath = booyahWebTemplate.path.dist.css + '/themes/' + booyahWebTemplate.themes[i] + '.css';
    mix.sass(srcPath, distPath, {
        precision: 5
    }).options({
        processCssUrls: false
    });
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// THEMES Variables
for (let i = 0; i < booyahWebTemplate.themes.length; i ++) {
    mix.combine([
        booyahWebTemplate.path.src.themes + '/' + booyahWebTemplate.themes[i] + '/scss/_variables.scss',
        'node_modules/bootstrap/scss/_functions.scss',
        'node_modules/bootstrap/scss/mixins/*',
        'node_modules/bootstrap/scss/_variables.scss',
        booyahWebTemplate.path.src.scss + '/_variables.scss',
        booyahWebTemplate.path.src.scss + '/_mixins.scss'
    ], booyahWebTemplate.path.dist.scss + '/_' + booyahWebTemplate.themes[i] + '-variables.scss');
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// THEMES JS

for (let i = 0; i < booyahWebTemplate.themes.length; i ++) {
    let srcPath = booyahWebTemplate.path.src.themes + '/' + booyahWebTemplate.themes[i] + '/js/theme.js';
    let distPath = booyahWebTemplate.path.dist.js + '/themes/' + booyahWebTemplate.themes[i] + '.js';
    mix.babel(srcPath, distPath);
}

/**
 * < Booyah Web Template
 ************************************************************************************/