<?php

use Redtree\BooyahWebTemplate\Services\Views\ThemeService;

if (!function_exists('theme_body_classes')) {
    function theme_body_classes($extra = [])
    {
        $theme = new ThemeService();
        $extra = is_array($extra) ? array_flatten($extra) : [];
        $base = [];

        // Aktuelles Theme
        $base[] = "theme__{$theme->name}";

        // Aktuelle Route
        $currentRoute = Route::currentRouteName();
        $currentRoute = str_replace('.', '--', $currentRoute);
        $currentRoute = str_slug($currentRoute);
        $base[] = "route__{$currentRoute}";
        $base[] = "has-header";

        // Grund- und Zusatz-Klassen zusammenfügen
        $classes_arr = array_merge($base, $extra);
        $classes_list = str_list_unique(implode(' ', $classes_arr));

        return $classes_list;
    }
}

if (!function_exists('thinsp')) {
    function thinsp($unit = '')
    {
        return '<span class="thinsp"><span>&nbsp;</span></span>' . get_abbr($unit);
    }
}

if (!function_exists('number_format_abbr')) {
    function number_format_abbr($value, $decimals = 2, $decimalFormat = 2, $useAbbr = false)
    {
        $formats = [
            1000000000000000 => '<abbr title="Billiarden">Brd.</abbr>',
            1000000000000 => '<abbr title="Billionen">Bio.</abbr>',
            1000000000 => '<abbr title="Milliarde">Mrd.</abbr>',
            1000000 => '<abbr title="Millionen">Mio.</abbr>',
            1000 => '<abbr title="Tausend">Tsd.</abbr>',
        ];

        if ($useAbbr) {
            foreach ($formats as $key => $format) {
                if ($value >= $key) {
                    $rounded = round($value / $key, $decimalFormat);
                    if ($rounded > $value / $key) {
                        $rounded -= pow(10, -$decimalFormat);
                    }

                    return number_format_EU($rounded, $decimalFormat) . thinsp() . $formats[$key];
                }
            }
        }


        return number_format_EU($value, $decimals);
    }
}

if (!function_exists('get_abbr')) {
    function get_abbr($abbreviation)
    {
        $abbreviations = __('booyahwebtemplate::abbreviations');
        $title = array_get($abbreviations, $abbreviation, $abbreviation);
        if ($title === $abbreviation) {
            return $abbreviation;
        }

        return '<abbr title="' . $title . '">' . $abbreviation . '</abbr>';
    }
}

if (!function_exists('format_melo')) {
    function format_melo($melo)
    {
        if (strlen($melo) != 33) {
            return $melo;
        }

        $seperator = (\Illuminate\Support\Facades\App::getLocale() == 'at' ? '.' : '&nbsp');
        $meloFormatted = substr($melo, 0, 2) . $seperator;
        $meloFormatted .= substr($melo, 2, 6) . $seperator;
        $meloFormatted .= substr($melo, 8, 5) . $seperator;
        $meloFormatted .= substr($melo, 13);

        return $meloFormatted;
    }
}
