<?php

namespace Redtree\Crypt;

use Jose\Component\Core\Algorithm;
use Jose\Component\Core\AlgorithmManager;
use Jose\Component\Core\Converter\StandardConverter;
use Jose\Component\Core\JWK;
use Jose\Component\Encryption\Compression\CompressionMethod;
use Jose\Component\Encryption\Compression\CompressionMethodManager;

class Crypto
{
    /**
     * @var Jose\Component\Core\AlgorithmManager
     */
    protected $keyManager;

    /**
     * @var Jose\Component\Core\AlgorithmManager
     */
    protected $contentManager;

    /**
     * @var Jose\Component\Encryption\Compression\CompressionMethodManager
     */
    protected $compresionManager;

    /**
     * @var Jose\Component\Core\Converter\StandardConverter
     */
    protected $converter;

    /**
     * @var string
     */
    private $key;

    /**
     * Describe me
     * @param mixed $parameters
     * @return void
     */
    public function __construct(Algorithm $contentAlgorhythm, Algorithm $keyManager, CompressionMethod $compression)
    {

        // The content encryption algorithm manager with the A256CBC-HS256 algorithm.
        $this->contentManager = AlgorithmManager::create([
            $contentAlgorhythm,
        ]);

        // The key encryption algorithm manager with the algorithm.
        $this->keyManager = AlgorithmManager::create([
            $keyManager,
        ]);

        // The compression method manager with the DEF (Deflate) method.
        $this->compressionManager = CompressionMethodManager::create([
            $compression,
        ]);

        // The JSON Converter.
        $this->converter = new StandardConverter();
    }

    /**
     * @param string $key
     * @return self
     */
    public function setKey(string $key):self
    {
        $this->key = $key;

        return $this;
    }

    /**
     * @return Jose\Component\Core\JWK
     */
    protected function jwk():\Jose\Component\Core\JWK
    {
        // Our key.
        return JWK::create([
            'kty' => 'oct',
            'k' => base64_encode($this->key),
        ]);
    }
}
