<?php

namespace Redtree\Crypt;

use Jose\Component\Core\Algorithm;
use Jose\Component\Encryption\Algorithm\ContentEncryption\A256CBCHS512;
use Jose\Component\Encryption\Algorithm\KeyEncryption\A256KW;
use Jose\Component\Encryption\Compression\CompressionMethod;
use Jose\Component\Encryption\Compression\Deflate;
use Jose\Component\Encryption\JWEDecrypter;
use Jose\Component\Encryption\Serializer\CompactSerializer;

class Decryption extends Crypto
{
    /**
     * @var array
     */
    private $result;

    /**
     * @var Jose\Component\Encryption\JWEDecrypter
     */
    private $decrypter;

    /**
     * Describe me
     * @param mixed $parameters
     * @return void
     */
    public function __construct(Algorithm $contentAlgorhythm = null, Algorithm $keyManager = null, CompressionMethod $compression = null)
    {
        parent::__construct($contentAlgorhythm ?? new A256CBCHS512(),
             $keyManager ?? new A256KW(),
             $compression ?? new Deflate()
         );
        // We instantiate our JWE Decrypter.
        $this->decrypter = new JWEDecrypter(
            $this->keyManager,
            $this->contentManager,
            $this->compressionManager
        );
    }

    /**
     * @param string $content
     * @return self
     */
    public function decrypt($content):self
    {
        $jwk = $this->jwk();


        // The serializer manager. We only use the JWE Compact Serialization Mode.
        $serializer = new CompactSerializer($this->converter);


        // We try to load the token.
        $jwe = $serializer->unserialize($content);

        // We decrypt the token. This method does NOT check the header.
        if ($this->decrypter->decryptUsingKey($jwe, $jwk, 0)) {
            $payload = $jwe->getPayload();
            $this->result = $this->converter->decode($payload);
        }

        return $this;
    }

    /**
     * @return array
     */
    public function get():array
    {
        return $this->result ?? [];
    }
}
