<?php

namespace Redtree\Crypt;

use Jose\Component\Encryption\Algorithm\ContentEncryption\A256CBCHS512;
use Jose\Component\Encryption\Algorithm\KeyEncryption\A256KW;
use Jose\Component\Encryption\Compression\Deflate;
use Jose\Component\Encryption\JWEBuilder;
use Jose\Component\Encryption\Serializer\CompactSerializer;

class Encryption extends Crypto
{
    /**
     * @var array
     */
    protected $result;

    /**
     * @var Jose\Component\Encryption\JWEBuilder
     */
    private $builder;

    public function __construct(Algorithm $contentAlgorhythm = null, Algorithm $keyManager = null, CompressionMethod $compression = null)
    {
        parent::__construct($contentAlgorhythm ?? new A256CBCHS512(),
            $keyManager ?? new A256KW(),
            $compression ?? new Deflate()
        );
        // We instantiate our JWE Builder.
        $this->builder = new JWEBuilder(
            $this->converter,
            $this->keyManager,
            $this->contentManager,
            $this->compressionManager
        );
    }

    /**
     * @param array $content
     */
    public function encrypt($content)
    {
        $jwk = $this->jwk();

        // The payload we want to encrypt. The payload MUST be a string hence we use our JSON Converter.
        $payload = $this->converter->encode($content);

        $jwe = $this->builder
            ->create()              // We want to create a new JWE
            ->withPayload($payload) // We set the payload
            ->withSharedProtectedHeader([
                'alg' => 'A256KW',        // Key Encryption Algorithm
                'enc' => 'A256CBC-HS512', // Content Encryption Algorithm
                'zip' => 'DEF'            // We enable the compression (irrelevant as the payload is small, just for the example).
            ])
            ->addRecipient($jwk)    // We add a recipient (a shared key or public key).
            ->build();

        $serializer = new CompactSerializer($this->converter);

        $token = (string) $serializer->serialize($jwe, 0);

        $this->result = $token;

        return $this;
    }

    /**
     * @return string
     */
    public function get():string
    {
        return $this->result ?? '';
    }
}
