<?php


declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use Redtree\Crypt\Decryption;
use Redtree\Crypt\Encryption;


class EncryptionTest extends TestCase
{
    public function testEncryption()
    {
        $cryptoTestValue = [
            'booyah' => 'encryption',
            'test' => 'success',
            'nested' => [
                'number-1' => 1,
                'number-2' => 2,
            ],
            'nested-wo-kindex' => [
                'one',
                'two',
                'three',
            ]
        ];

        $token = str_random(64);

        $crypto = tap(new Encryption())
            ->setKey($token)
            ->encrypt($cryptoTestValue);

        $decrypted = tap(new Decryption())
            ->setKey($token)
            ->decrypt($crypto->get());

        $this->assertSame($decrypted->get(), $cryptoTestValue);
    }
}
