<?php

namespace Redtree\EnetClient;

class EnetClient extends Client
{
    const ENERGY_TYPE_POWER = 'power';
    const ENERGY_TYPE_GAS = 'gas';

    /**
     * @var string
     */
    protected $energyType;

    /**
     * @var array
     */
    protected $data;

    public function __construct(array $options = [])
    {
        parent::__construct($options);

        $this->energyType = self::ENERGY_TYPE_POWER;
        $this->data = [];

        $this->setBaseUrl(config('enetclient.baseUrl'));
        $this->setHeaders(['token' => config('enetclient.token')]);
    }

    /**
     * @param string $type
     * @return EnetClient
     */
    public function setEnergyType($type) : EnetClient
    {
        $this->energyType = $type;

        return $this;
    }

    /**
     * @param array $data
     * @return EnetClient
     */
    public function setData(array $data) : EnetClient
    {
        $this->data = $data;

        return $this;
    }

    /**
     * @return mixed|\Psr\Http\Message\ResponseInterface
     * @throws \Exception
     */
    public function getTaxes()
    {
        return $this->addToPayload()->setEndpoint('api/bocc/taxes')->send();
    }

    protected function addToPayload()
    {
        return $this->addPayload(['energyType' => $this->energyType])->addPayload($this->data);
    }
}