<?php

namespace Redtree\EnetClient;

use Illuminate\Support\ServiceProvider;

class EnetClientServiceProvider extends ServiceProvider
{
    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        // Publishing is only necessary when using the CLI.
        if ($this->app->runningInConsole()) {

            // Publishing the configuration file.
            $this->publishes([
                __DIR__.'/../config/enetclient.php' => config_path('enetclient.php'),
            ], 'enetclient.config');
        }
    }

    /**
     * Register any package services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/enetclient.php', 'enetclient');

        // Register the service the package provides.
        $this->app->singleton('enetclient', function ($app) {
            return new EnetClient;
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['enetclient'];
    }
}